/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.TracksAndWayPoints;
import gps.log.out.GPSFile;

public final class GPSArray
extends GPSFile {
    private BT747Vector track;
    private BT747Vector gpsWayPoints;
    private TracksAndWayPoints result = new TracksAndWayPoints();
    boolean isNewTrack = true;

    public GPSArray() {
        this.numberOfPasses = 1;
    }

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.result = new TracksAndWayPoints();
        this.gpsWayPoints = this.result.waypoints;
        this.track = JavaLibBridge.getVectorInstance();
    }

    public final boolean needPassToFindFieldsActivatedInLog() {
        return false;
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord) || this.ptFilters[1].doFilter(gPSRecord);
    }

    public void finaliseFile() {
        this.endTrack();
    }

    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            return true;
        }
        return false;
    }

    private void endTrack() {
        this.result.tracks.addElement(this.track);
        this.track = JavaLibBridge.getVectorInstance();
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (this.ptFilters[1].doFilter(gPSRecord) && this.nbrOfPassesToGo == 0) {
            this.gpsWayPoints.addElement(gPSRecord.cloneRecord());
        }
        boolean bl = this.ptFilters[0].doFilter(gPSRecord);
        boolean bl2 = this.needsToSplitTrack;
        if (!bl) {
            bl2 |= !this.ignoreBadPoints;
        }
        if (!this.isNewTrack && !this.firstRecord && this.needsToSplitTrack) {
            this.endTrack();
        }
        if (bl) {
            this.isNewTrack = false;
            this.track.addElement(gPSRecord.cloneRecord());
        }
    }

    protected int createFile(int n, String string, boolean bl) {
        ++this.filesCreated;
        return 0;
    }

    protected final void closeFile() {
    }
}

