/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;

public final class GPSCSVFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private char decimalPoint = (char)46;
    private char fieldSep = (char)44;
    private char satSeperator = (char)59;
    private int posDigits;
    private int heightDigits;
    private String dataPrefix;
    private String headerPrefix;

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        String string2;
        String string3;
        String string4;
        super.initialiseFile(bT747Path, string, n);
        if (this.getParamObject().hasParam("csv-datefmt")) {
            this.getParamObject().getIntParam("csv-datefmt");
        }
        if ((string4 = this.getParamObject().getStringParam("csv-decimal")) != null) {
            this.decimalPoint = string4.charAt(0);
        }
        if ((string3 = this.getParamObject().getStringParam("csv-fieldsep")) != null) {
            this.fieldSep = string3.charAt(0);
        }
        if ((string2 = this.getParamObject().getStringParam("csv-satsep")) != null) {
            this.satSeperator = string2.charAt(0);
        }
        this.posDigits = this.getParamObject().hasParam("pos-digits") ? this.getParamObject().getIntParam("pos-digits") : 6;
        this.heightDigits = this.getParamObject().hasParam("height-digits") ? this.getParamObject().getIntParam("height-digits") : 3;
        this.headerPrefix = this.getParamObject().hasParam("data-csv-prefix") ? this.getParamObject().getStringParam("data-csv-prefix") : "";
        this.dataPrefix = this.getParamObject().hasParam("header-csv-prefix") ? this.getParamObject().getStringParam("header-csv-prefix") : "";
    }

    public final boolean needPassToFindFieldsActivatedInLog() {
        return true;
    }

    protected final void writeFileHeader(String string) {
        this.rec.setLength(0);
        this.rec.append(this.headerPrefix);
        this.rec.append("INDEX");
        if (this.selectedFileFields.hasRcr()) {
            this.rec.append(this.fieldSep + "RCR");
        }
        if (this.selectedFileFields.hasUtc()) {
            this.rec.append(this.fieldSep + "DATE" + this.fieldSep + "TIME");
        }
        if (this.selectedFileFields.hasValid()) {
            this.rec.append(this.fieldSep + "VALID");
        }
        if (this.selectedFileFields.hasLatitude()) {
            this.rec.append(this.fieldSep + "LATITUDE" + this.fieldSep + "N/S");
        }
        if (this.selectedFileFields.hasLongitude()) {
            this.rec.append(this.fieldSep + "LONGITUDE" + this.fieldSep + "E/W");
        }
        if (this.selectedFileFields.hasHeight()) {
            if (!this.imperial) {
                this.rec.append(this.fieldSep + "HEIGHT(m)");
            } else {
                this.rec.append(this.fieldSep + "HEIGHT(ft)");
            }
        }
        if (this.selectedFileFields.hasGeoid()) {
            if (!this.imperial) {
                this.rec.append(this.fieldSep + "GEOSEP(m)");
            } else {
                this.rec.append(this.fieldSep + "GEOSEP(ft)");
            }
        }
        if (this.selectedFileFields.hasSpeed()) {
            if (!this.imperial) {
                this.rec.append(this.fieldSep + "SPEED(km/h)");
            } else {
                this.rec.append(this.fieldSep + "SPEED(mph)");
            }
        }
        if (this.selectedFileFields.hasHeading()) {
            this.rec.append(this.fieldSep + "HEADING");
        }
        if (this.selectedFileFields.hasDsta()) {
            this.rec.append(this.fieldSep + "DSTA");
        }
        if (this.selectedFileFields.hasDage()) {
            this.rec.append(this.fieldSep + "DAGE");
        }
        if (this.selectedFileFields.hasPdop()) {
            this.rec.append(this.fieldSep + "PDOP");
        }
        if (this.selectedFileFields.hasHdop()) {
            this.rec.append(this.fieldSep + "HDOP");
        }
        if (this.selectedFileFields.hasVdop()) {
            this.rec.append(this.fieldSep + "VDOP");
        }
        if (this.selectedFileFields.hasNsat()) {
            this.rec.append(this.fieldSep + "NSAT (USED/VIEW)");
        }
        if (this.selectedFileFields.hasDistance()) {
            if (!this.imperial) {
                this.rec.append(this.fieldSep + "DISTANCE(m)");
            } else {
                this.rec.append(this.fieldSep + "DISTANCE(ft)");
            }
        }
        if (this.selectedFileFields.hasSid()) {
            this.rec.append(this.fieldSep + "SAT INFO (SID");
            if (this.selectedFileFields.hasEle()) {
                this.rec.append("-ELE");
            }
            if (this.selectedFileFields.hasAzi()) {
                this.rec.append("-AZI");
            }
            if (this.selectedFileFields.hasSnr()) {
                this.rec.append("-SNR");
            }
            this.rec.append(")");
        }
        if (this.selectedFileFields.hasVoxStr()) {
            this.rec.append(this.fieldSep + "VOX");
        }
        if (this.addLogConditionInfo) {
            this.rec.append(this.fieldSep + "LOGTIME(s)");
            this.rec.append(this.fieldSep + "LOGDIST(m)");
            this.rec.append(this.fieldSep + "LOGSPD(km/h)");
        }
        this.rec.append(this.fieldSep + "\r\n");
        this.writeTxt(this.rec.toString());
        this.rec.setLength(0);
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord) || this.ptFilters[1].doFilter(gPSRecord);
    }

    private final void appendNumber(StringBuffer stringBuffer, String string) {
        if (this.decimalPoint == '.') {
            stringBuffer.append(string);
        } else {
            String string2 = string.replace('.', this.decimalPoint);
            stringBuffer.append(string2);
        }
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (this.cachedRecordIsNeeded(gPSRecord)) {
            this.rec.setLength(0);
            this.rec.append(this.dataPrefix);
            if (gPSRecord.hasRecCount()) {
                this.rec.append(gPSRecord.getRecCount());
            }
            if (this.selectedFileFields.hasRcr()) {
                this.rec.append(this.fieldSep);
                if (gPSRecord.hasRcr()) {
                    this.rec.append(CommonOut.getRCRstr(gPSRecord));
                }
            }
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                this.rec.append(this.fieldSep + CommonOut.getDateNumStr(this.t) + this.fieldSep + CommonOut.getTimeStr(this.t));
                if (gPSRecord.hasMillisecond()) {
                    this.rec.append(this.decimalPoint);
                    if (gPSRecord.milisecond < 100) {
                        this.rec.append('0');
                    }
                    if (gPSRecord.milisecond < 10) {
                        this.rec.append('0');
                    }
                    this.rec.append(gPSRecord.milisecond);
                }
            } else if (this.selectedFileFields.hasUtc()) {
                this.rec.append(this.fieldSep);
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasValid() && this.selectedFileFields.hasValid()) {
                this.rec.append(this.fieldSep);
                this.rec.append(CommonOut.getFixText(gPSRecord.getValid()));
            } else if (this.selectedFileFields.hasValid()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getLatitude(), this.posDigits));
                if (gPSRecord.getLatitude() >= 0.0) {
                    this.rec.append(this.fieldSep + "N");
                } else {
                    this.rec.append(this.fieldSep + "S");
                }
            } else if (this.selectedFileFields.hasLatitude()) {
                this.rec.append(this.fieldSep);
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getLongitude(), this.posDigits));
                if (gPSRecord.getLongitude() >= 0.0) {
                    this.rec.append(this.fieldSep + "E");
                } else {
                    this.rec.append(this.fieldSep + "W");
                }
            } else if (this.selectedFileFields.hasLongitude()) {
                this.rec.append(this.fieldSep);
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                this.rec.append(this.fieldSep);
                if (!this.imperial) {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getHeight(), this.heightDigits));
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getHeight() * 3.28084f, this.heightDigits));
                }
            } else if (this.selectedFileFields.hasHeight()) {
                this.rec.append(this.fieldSep);
            }
            if (this.selectedFileFields.hasGeoid()) {
                if (gPSRecord.hasPosition()) {
                    float f = gPSRecord.hasGeoid() ? gPSRecord.getGeoid() : (float)((long)(10.0 * ExternalUtils.wgs84Separation(gPSRecord.getLatitude(), gPSRecord.getLongitude()))) / 10.0f;
                    if (this.imperial) {
                        f *= 3.28084f;
                    }
                    this.appendNumber(this.rec, JavaLibBridge.toString(f, this.heightDigits));
                    this.rec.append(this.fieldSep);
                } else {
                    this.rec.append(this.fieldSep);
                }
            }
            if (gPSRecord.hasSpeed() && this.selectedFileFields.hasSpeed()) {
                this.rec.append(this.fieldSep);
                if (!this.imperial) {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getSpeed(), 3));
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getSpeed() * 0.6213712f, 3));
                }
            } else if (this.selectedFileFields.hasSpeed()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasHeading() && this.selectedFileFields.hasHeading()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.getHeading(), 6));
            } else if (this.selectedFileFields.hasHeading()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasDsta() && this.selectedFileFields.hasDsta()) {
                this.rec.append(this.fieldSep);
                this.rec.append(gPSRecord.getDsta());
            } else if (this.selectedFileFields.hasDsta()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasDage() && this.selectedFileFields.hasDage()) {
                this.rec.append(this.fieldSep);
                this.rec.append(gPSRecord.getDage());
            } else if (this.selectedFileFields.hasDage()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasPdop() && this.selectedFileFields.hasPdop()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString((float)gPSRecord.getPdop() / 100.0f, 2));
            } else if (this.selectedFileFields.hasPdop()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasHdop() && this.selectedFileFields.hasHdop()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2));
            } else if (this.selectedFileFields.hasHdop()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasVdop() && this.selectedFileFields.hasVdop()) {
                this.rec.append(this.fieldSep);
                this.appendNumber(this.rec, JavaLibBridge.toString((float)gPSRecord.getVdop() / 100.0f, 2));
            } else if (this.selectedFileFields.hasVdop()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasNsat() && this.selectedFileFields.hasNsat()) {
                this.rec.append(this.fieldSep);
                this.rec.append((gPSRecord.getNsat() & 0xFF00) >> 8);
                this.rec.append("(" + (gPSRecord.getNsat() & 0xFF) + ")");
            } else if (this.selectedFileFields.hasNsat()) {
                this.rec.append(this.fieldSep);
            }
            if (gPSRecord.hasDistance() && this.selectedFileFields.hasDistance()) {
                this.rec.append(this.fieldSep);
                if (!this.imperial) {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.distance, 2));
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString(gPSRecord.distance * 3.28083989501312, 2));
                }
            } else if (this.selectedFileFields.hasDistance()) {
                this.rec.append(this.fieldSep);
            }
            if (this.selectedFileFields.hasSid()) {
                int n = 0;
                this.rec.append(this.fieldSep);
                if (gPSRecord.hasSid()) {
                    for (int i = gPSRecord.sid.length - 1; i >= 0; --i) {
                        if (n != 0) {
                            this.rec.append(this.satSeperator);
                        }
                        if (gPSRecord.sidinuse[n]) {
                            this.rec.append('#');
                        }
                        if (gPSRecord.sid[n] < 10) {
                            this.rec.append('0');
                        }
                        this.rec.append(gPSRecord.sid[n]);
                        if (this.selectedFileFields.hasEle()) {
                            this.rec.append('-');
                            if (gPSRecord.hasEle()) {
                                if (gPSRecord.ele[n] < 10) {
                                    this.rec.append('0');
                                }
                                this.rec.append(gPSRecord.ele[n]);
                            }
                        }
                        if (this.selectedFileFields.hasAzi()) {
                            this.rec.append('-');
                            if (gPSRecord.hasAzi()) {
                                if (gPSRecord.azi[n] < 10) {
                                    this.rec.append('0');
                                }
                                this.rec.append(gPSRecord.azi[n]);
                            }
                        }
                        if (this.selectedFileFields.hasSnr()) {
                            this.rec.append('-');
                            if (gPSRecord.hasSnr()) {
                                if (gPSRecord.snr[n] < 10) {
                                    this.rec.append('0');
                                }
                                this.rec.append(gPSRecord.snr[n]);
                            }
                        }
                        ++n;
                    }
                }
            }
            if (this.selectedFileFields.hasVoxStr()) {
                this.rec.append(this.fieldSep);
                if (gPSRecord.voxStr != null) {
                    this.rec.append(gPSRecord.voxStr);
                }
            }
            if (this.addLogConditionInfo) {
                this.rec.append(this.fieldSep);
                if (gPSRecord.logPeriod % 10 == 0) {
                    this.rec.append(gPSRecord.logPeriod / 10);
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString((double)gPSRecord.logPeriod / 10.0, 1));
                }
                this.rec.append(this.fieldSep);
                if (gPSRecord.logDistance % 10 == 0) {
                    this.rec.append(gPSRecord.logDistance / 10);
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString((double)gPSRecord.logDistance / 10.0, 1));
                }
                this.rec.append(this.fieldSep);
                if (gPSRecord.logSpeed % 10 == 0) {
                    this.rec.append(gPSRecord.logSpeed / 10);
                } else {
                    this.appendNumber(this.rec, JavaLibBridge.toString((double)gPSRecord.logSpeed / 10.0, 1));
                }
            }
            this.rec.append(this.fieldSep);
            this.rec.append("\r\n");
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }
}

