/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;
import gps.log.out.WayPointStyle;
import gps.tracks.PolylineEncoder;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class GPSGoogleStaticMapUrl
extends GPSFile {
    private BT747Vector urls = JavaLibBridge.getVectorInstance();
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean isWayType;
    private boolean isNewTrack = true;
    private int currentFilter;
    private final Track track = new Track();
    private final Track waypoints = new Track();
    private int trackIndex = 0;
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private int xSize = 400;
    private int ySize = 400;
    private int maxLen = 2000;
    private final BT747Hashtable icons = JavaLibBridge.getHashtableInstance(10);
    private int previousTime = 0;
    private int previousRec = 0;

    public GPSGoogleStaticMapUrl() {
        this.numberOfPasses = 2;
    }

    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.currentFilter = 1;
        this.isWayType = true;
        this.resetTrack();
    }

    private final void resetTrack() {
        this.track.removeAll();
    }

    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.isWayType = false;
            this.currentFilter = 0;
            return true;
        }
        return false;
    }

    protected final void writeFileHeader(String string) {
    }

    protected final void writeDataHeader() {
        if (!this.isWayType) {
            this.isNewTrack = true;
            this.minlat = 90.0;
            this.maxlat = -90.0;
            this.minlon = 180.0;
            this.maxlon = -180.0;
        }
    }

    protected final void endTrack(String string) {
        String string2;
        PolylineEncoder polylineEncoder = new PolylineEncoder();
        int n = 10;
        do {
            BT747Hashtable bT747Hashtable = polylineEncoder.dpEncode(this.track);
            string2 = (String)bT747Hashtable.get("encodedPoints");
            string2 = PolylineEncoder.replace(string2, "|", "%7C");
        } while ((string2 = PolylineEncoder.replace(string2, "\\\\", "\\")).length() > this.maxLen && n-- > 0);
        if (string2.length() >= 2) {
            this.rec.setLength(0);
            this.rec.append("http://maps.google.com/maps/api/staticmap?sensor=false&size=");
            this.rec.append(this.xSize);
            this.rec.append("x");
            this.rec.append(this.ySize);
            this.rec.append(this.keyCode());
            this.rec.append("&path=weight:3");
            this.rec.append("|color:0x");
            this.rec.append(this.goodTrackColor);
            this.rec.append("|enc:");
            this.rec.append(string2);
            this.urls.addElement(this.rec.toString());
            Generic.debug(this.rec.toString());
            this.rec.setLength(0);
        }
        ++this.trackIndex;
        this.resetTrack();
    }

    private final String keyCode() {
        String string = this.getParamObject().getStringParam("googlemapkey");
        if (string != null && string.length() != 0) {
            return "&key=" + string;
        }
        return "";
    }

    protected final void writeDataFooter() {
        if (this.isWayType) {
            if (this.waypoints.size() != 0) {
                this.rec.setLength(0);
                this.rec.append("var baseIcon = new GIcon(G_DEFAULT_ICON);\nbaseIcon.iconSize = new GSize(32, 32);\n");
                BT747Hashtable bT747Hashtable = this.icons.iterator();
                while (bT747Hashtable.hasNext()) {
                    Object object = bT747Hashtable.nextKey();
                    this.rec.append("var ICON");
                    this.rec.append((String)object);
                    this.rec.append("=new GIcon(baseIcon);");
                    this.rec.append("ICON");
                    this.rec.append((String)object);
                    this.rec.append(".image='");
                    this.rec.append((String)bT747Hashtable.get(object));
                    this.rec.append("';\n");
                }
                for (int i = 0; i < this.waypoints.size(); ++i) {
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLatDouble(), 5));
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLonDouble(), 5));
                }
                this.rec.setCharAt(this.rec.length() - 1, ']');
                this.rec.setLength(0);
                this.waypoints.removeAll();
            }
            this.resetTrack();
        } else {
            this.endTrack(this.goodTrackColor);
            this.splitOrEndTrack();
        }
    }

    private final void splitOrEndTrack() {
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (!this.ptFilters[this.currentFilter].doFilter(gPSRecord)) {
            if (!(this.isWayType || this.isNewTrack || this.firstRecord || this.ignoreBadPoints)) {
                this.isNewTrack = true;
                if (this.track.size() != 0) {
                    Trackpoint trackpoint = this.track.get(this.track.size() - 1);
                    this.endTrack(this.goodTrackColor);
                    this.track.addTrackpoint(trackpoint);
                }
            }
            if (!this.isWayType && this.cachedRecordIsNeeded(gPSRecord)) {
                if (gPSRecord.getLatitude() < this.minlat) {
                    this.minlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLatitude() > this.maxlat) {
                    this.maxlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLongitude() < this.minlon) {
                    this.minlon = gPSRecord.getLongitude();
                }
                if (gPSRecord.getLongitude() > this.maxlon) {
                    this.maxlon = gPSRecord.getLongitude();
                }
            }
        } else {
            Object object;
            if (!this.isWayType) {
                this.rec.setLength(0);
                if (this.isNewTrack || this.needsToSplitTrack) {
                    this.isNewTrack = false;
                    if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                        if (!this.needsToSplitTrack) {
                            this.track.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                            if (gPSRecord.hasUtc()) {
                                this.previousTime = gPSRecord.getUtc();
                                this.previousRec = gPSRecord.recCount;
                            }
                            this.endTrack(this.badTrackColor);
                        } else {
                            this.endTrack(this.goodTrackColor);
                            this.splitOrEndTrack();
                        }
                    }
                    this.resetTrack();
                }
            }
            if (gPSRecord.hasUtc()) {
                this.previousTime = gPSRecord.getUtc();
                this.previousRec = gPSRecord.getRecCount();
            }
            if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                object = new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude());
                this.track.addTrackpoint((Trackpoint)object);
                if (((Trackpoint)object).getLatDouble() < this.minlat) {
                    this.minlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLatDouble() > this.maxlat) {
                    this.maxlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLonDouble() < this.minlon) {
                    this.minlon = ((Trackpoint)object).getLonDouble();
                }
                if (((Trackpoint)object).getLonDouble() > this.maxlon) {
                    this.maxlon = ((Trackpoint)object).getLonDouble();
                }
            }
            if (this.isWayType && gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                this.waypoints.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                object = CommonOut.getRCRstr(gPSRecord);
                String string = "";
                if (this.icons.get(object) == null) {
                    WayPointStyle wayPointStyle = ((String)object).length() > 0 && ((String)object).charAt(0) == 'X' ? CommonOut.getWayPointStyles().get(((String)object).substring(1)) : (((String)object).length() > 1 ? CommonOut.getWayPointStyles().get("M") : CommonOut.getWayPointStyles().get((String)object));
                    if (wayPointStyle != null) {
                        String string2 = wayPointStyle.getIconUrl();
                        this.icons.put(object, string2);
                        string = "ICON" + (String)object;
                    }
                } else {
                    string = "ICON" + (String)object;
                }
            }
            this.rec.setLength(0);
        }
    }

    public final void finaliseFile() {
        if (this.isOpen()) {
            for (int i = 0; i < this.urls.size(); ++i) {
                this.writeTxt((String)this.urls.elementAt(i));
                this.writeTxt("\r\n");
            }
            this.writeDataFooter();
        }
        super.finaliseFile();
    }
}

