/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.out.GPSFile;

public final class GPSPostGISFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private final StringBuffer recPost = new StringBuffer(1024);
    private String satSeperator = ";";
    private String tableName = "defaultpostgistable";
    private String dbName = "defaultdb";
    private char separatorChar = (char)32;

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        if (this.getParamObject().hasParam("postgis-table")) {
            this.tableName = this.getParamObject().getStringParam("postgis-table");
        }
    }

    public final boolean needPassToFindFieldsActivatedInLog() {
        return true;
    }

    protected final void writeFileHeader(String string) {
        this.rec.setLength(0);
        this.recPost.setLength(0);
        this.rec.append("CREATE TABLE ");
        this.rec.append(this.tableName);
        this.rec.append(" ( track_id INTEGER,track_starttime TIMESTAMP,track_endtime TIMESTAMP);\r\n");
        this.rec.append("SELECT AddGeometryColumn('" + this.tableName + "','" + "track_geom" + "'," + 4236 + ",'MULTILINESTRING'" + ",3" + ");\r\n");
        this.rec.append("BEGIN;\r\n");
        this.rec.append("INSERT INTO " + this.tableName);
        this.rec.append(" ( ");
        this.rec.append("track_id,track_starttime,track_endtime,");
        this.rec.append("track_geom)\r\nVALUES (\r\n");
        this.rec.append("1, '1999-01-01 10:00', '1999-01-01 11:00',\r\n");
        this.rec.append("ST_GeomFromEWKT('SRID=4236;MULTILINESTRING((\r\n");
        this.separatorChar = (char)32;
        this.writeTxt(this.rec.toString());
        this.rec.setLength(0);
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord) || this.ptFilters[1].doFilter(gPSRecord);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (this.cachedRecordIsNeeded(gPSRecord) && gPSRecord.hasPosition() && this.selectedFileFields.hasPosition()) {
            this.rec.setLength(0);
            this.rec.append(this.separatorChar);
            this.separatorChar = (char)44;
            this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), 6));
            this.rec.append(' ');
            this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), 6));
            this.rec.append(' ');
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                if (!this.imperial) {
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), 3));
                } else {
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight() * 3.28084f, 3));
                }
            } else {
                this.rec.append(0);
            }
            this.rec.append("\r\n");
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    public void finaliseFile() {
        this.rec.setLength(0);
        this.rec.append("))')");
        this.rec.append(" );\r\n");
        this.rec.append("COMMIT;\r\n");
        this.writeTxt(this.rec.toString());
        this.rec.setLength(0);
        super.finaliseFile();
    }
}

