/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Semaphore;
import bt747.sys.interfaces.BT747Vector;
import gps.connection.GPSrxtx;
import gps.connection.NMEADecoderState;
import gps.mvc.commands.CmdVisitor;
import gps.mvc.commands.GpsLinkExecCommand;

public final class GpsLinkHandler {
    private GPSrxtx gpsRxTx = null;
    private boolean eraseOngoing = false;
    private final BT747Vector sentCmds = JavaLibBridge.getVectorInstance();
    private final BT747Vector toSendCmds = JavaLibBridge.getVectorInstance();
    private boolean gpsDecode = true;
    private boolean logDownloadOngoing;
    private int nextCmdSendTime = 0;
    private final BT747Semaphore cmdBuffersAccess = JavaLibBridge.getSemaphoreInstance(1);
    private int logTimer = 0;
    private int downloadTimeOut = 3500;

    public final void setGPSRxtx(GPSrxtx gPSrxtx) {
        if (this.gpsRxTx != null) {
            // empty if block
        }
        this.gpsRxTx = gPSrxtx;
    }

    public final GPSrxtx getGPSRxtx() {
        return this.gpsRxTx;
    }

    public final boolean isConnected() {
        return this.gpsRxTx.isConnected();
    }

    public final void sendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.cmdBuffersAccess.down();
        int n = this.sentCmds.size();
        if (!this.isEraseOngoing() && n == 0 && Generic.getTimeStamp() > this.nextCmdSendTime) {
            this.doSendCmdUnprotected(gpsLinkExecCommand);
        } else if (n < 20) {
            this.toSendCmds.addElement(gpsLinkExecCommand);
            if (Generic.isDebug()) {
                Generic.debug("#" + gpsLinkExecCommand);
            }
        }
        this.cmdBuffersAccess.up();
    }

    public final boolean isGpsDecode() {
        return this.gpsDecode;
    }

    public final void setGpsDecode(boolean bl) {
        this.gpsDecode = bl;
        this.updateIgnoreNMEA();
    }

    private final boolean isLogDownloadOngoing() {
        return this.logDownloadOngoing;
    }

    public final void setLogOrEraseOngoing(boolean bl) {
        this.logDownloadOngoing = bl;
        this.updateIgnoreNMEA();
    }

    public final void updateIgnoreNMEA() {
        this.setIgnoreNMEA(!this.gpsDecode || this.isLogDownloadOngoing());
    }

    public final void setIgnoreNMEA(boolean bl) {
        NMEADecoderState.setIgnoreNMEA(bl);
    }

    public void doSendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.cmdBuffersAccess.down();
        this.doSendCmdUnprotected(gpsLinkExecCommand);
        this.cmdBuffersAccess.up();
    }

    private final void doSendCmdUnprotected(GpsLinkExecCommand gpsLinkExecCommand) {
        this.resetLogTimeOut();
        try {
            if (gpsLinkExecCommand.hasAck()) {
                this.sentCmds.addElement(gpsLinkExecCommand);
            }
            gpsLinkExecCommand.execute(this.getGPSRxtx());
        }
        catch (Exception exception) {
            Generic.debug("doSendCmd", exception);
        }
        this.nextCmdSendTime = Generic.getTimeStamp() + 30;
        if (this.sentCmds.size() > 10) {
            this.sentCmds.removeElementAt(0);
        }
    }

    protected final void initConnected() {
        this.nextCmdSendTime = Generic.getTimeStamp() + 500;
    }

    protected final void checkSendCmdFromQueue() {
        int n = Generic.getTimeStamp();
        if (!this.isEraseOngoing()) {
            this.cmdBuffersAccess.down();
            try {
                if (this.sentCmds.size() != 0 && n - this.logTimer >= this.downloadTimeOut) {
                    if (Generic.isDebug()) {
                        Generic.debug("Timeout: " + n + "-" + this.logTimer + ">" + this.downloadTimeOut, null);
                        for (int i = 0; i < this.sentCmds.size(); ++i) {
                            Generic.debug("No ack:" + this.sentCmds.elementAt(i));
                        }
                    }
                    this.sentCmds.removeAllElements();
                    this.logTimer = n;
                }
                if (this.toSendCmds.size() != 0 && this.sentCmds.size() < 4 && Generic.getTimeStamp() > this.nextCmdSendTime) {
                    GpsLinkExecCommand gpsLinkExecCommand = (GpsLinkExecCommand)this.toSendCmds.elementAt(0);
                    if (this.sentCmds.size() == 0 || !gpsLinkExecCommand.mustBeFirstInQueue()) {
                        this.doSendCmdUnprotected(gpsLinkExecCommand);
                        this.toSendCmds.removeElementAt(0);
                    }
                }
            }
            catch (Exception exception) {
                Generic.debug("checkSendCmdFromQueue", exception);
            }
            this.cmdBuffersAccess.up();
        }
    }

    public final boolean removeFromSentCmds(CmdVisitor cmdVisitor) {
        int n = -1;
        this.cmdBuffersAccess.down();
        try {
            int n2;
            for (n2 = 0; n2 < this.sentCmds.size(); ++n2) {
                if (!cmdVisitor.isAcknowledgeOf((GpsLinkExecCommand)this.sentCmds.elementAt(n2))) continue;
                n = n2;
                break;
            }
            for (n2 = n; n2 >= 0; --n2) {
                this.sentCmds.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            Generic.debug("removeFromSentCmds", exception);
        }
        this.cmdBuffersAccess.up();
        return n != -1;
    }

    public final int getOutStandingCmdsCount() {
        this.cmdBuffersAccess.down();
        int n = this.sentCmds.size() + this.toSendCmds.size();
        this.cmdBuffersAccess.up();
        return n;
    }

    protected final Object getResponse() {
        return this.gpsRxTx.getResponse();
    }

    private final boolean isEraseOngoing() {
        return this.eraseOngoing;
    }

    protected final void setEraseOngoing(boolean bl) {
        this.eraseOngoing = bl;
    }

    protected final void setDownloadTimeOut(int n) {
        this.downloadTimeOut = n;
    }

    protected final void resetLogTimeOut() {
        this.logTimer = Generic.getTimeStamp();
    }

    protected final int timeSinceLastStamp() {
        return Generic.getTimeStamp() - this.logTimer;
    }
}

