/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747HashSet;
import gps.GPSListener;
import gps.GpsEvent;
import gps.ProtocolConstants;
import gps.connection.GPSrxtx;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.mvc.GpsLinkHandler;
import gps.mvc.HoluxModel;
import gps.mvc.MtkModel;
import gps.mvc.SkytraqModel;
import gps.mvc.WPModel;

public class GpsModel
implements ProtocolConstants {
    private final GpsLinkHandler handler;
    private MtkModel mtkModel;
    private int protocol = -1;
    private boolean GPS_STATS = false;
    private final GPSRecord gpsPos = GPSRecord.getLogFormatRecord(0);
    private final BT747HashSet listeners = JavaLibBridge.getHashSetInstance();

    public GpsModel(GPSrxtx gPSrxtx, int n) {
        this.handler = new GpsLinkHandler();
        this.setProtocol(n);
        this.setGPSRxtx(gPSrxtx);
    }

    public final void setProtocol(int n) {
        if (this.protocol != n) {
            this.protocol = n;
            switch (n) {
                case 0: 
                case 3: {
                    this.mtkModel = new MtkModel(this, this.handler);
                    break;
                }
                case 1: {
                    this.mtkModel = new WPModel(this, this.handler);
                    break;
                }
                case 2: 
                case 5: {
                    this.mtkModel = new HoluxModel(this, this.handler);
                    break;
                }
                case 4: {
                    this.mtkModel = new SkytraqModel(this, this.handler);
                    break;
                }
                default: {
                    this.mtkModel = null;
                }
            }
        }
    }

    public final MtkModel getMtkModel() {
        return this.mtkModel;
    }

    public final GpsLinkHandler getHandler() {
        return this.handler;
    }

    public final void setGPSRxtx(GPSrxtx gPSrxtx) {
        this.handler.setGPSRxtx(gPSrxtx);
    }

    public final void setStats(boolean bl) {
        this.GPS_STATS = bl;
    }

    public void setAllUnavailable() {
        this.mtkModel.setAllUnavailable();
    }

    private final void analyzeGPRMC(String[] stringArray, GPSRecord gPSRecord) {
        if (CommonIn.analyzeGPRMC(stringArray, gPSRecord) != 0) {
            this.postGpsEvent(3, gPSRecord);
        }
    }

    private final void analyzeGPGGA(String[] stringArray, GPSRecord gPSRecord) {
        if (CommonIn.analyzeGPGGA(stringArray, gPSRecord) != 0) {
            gPSRecord.height -= gPSRecord.geoid;
            this.postGpsEvent(4, gPSRecord);
        }
    }

    final boolean analyseResponse(Object object) {
        return this.mtkModel.analyseResponse(object);
    }

    public final boolean analyseNMEA(String[] stringArray) {
        boolean bl = false;
        try {
            if (stringArray.length == 0) {
                Generic.debug("Problem - report NMEA is 0 length");
            } else if (this.handler.isGpsDecode() && !this.isLogDownloadOnGoing() && stringArray[0].length() != 0 && stringArray[0].charAt(0) == 'G') {
                if (stringArray[0].startsWith("GPGGA")) {
                    this.analyzeGPGGA(stringArray, this.gpsPos);
                } else if (stringArray[0].startsWith("GPRMC")) {
                    this.analyzeGPRMC(stringArray, this.gpsPos);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            Generic.debug("AnalyzeNMEA", exception);
        }
        return bl;
    }

    public final void setGpsDecode(boolean bl) {
        this.handler.setGpsDecode(bl);
    }

    protected void postGpsEvent(int n, Object object) {
        this.postEvent(new GpsEvent(n, object));
    }

    public final GPSRecord getGpsRecord() {
        return this.gpsPos;
    }

    public final void addListener(GPSListener gPSListener) {
        this.listeners.add(gPSListener);
    }

    public final void removeListener(GPSListener gPSListener) {
        this.listeners.remove(gPSListener);
    }

    protected final void postEvent(GpsEvent gpsEvent) {
        BT747HashSet bT747HashSet = this.listeners.iterator();
        while (bT747HashSet.hasNext()) {
            GPSListener gPSListener = (GPSListener)bT747HashSet.next();
            gPSListener.gpsEvent(gpsEvent);
        }
    }

    public final int getStartAddr() {
        return this.mtkModel.getStartAddr();
    }

    public final int getEndAddr() {
        return this.mtkModel.getEndAddr();
    }

    public final boolean isLogDownloadOnGoing() {
        return this.mtkModel.isLogDownloadOngoing();
    }

    public final int getNextReadAddr() {
        return this.mtkModel.getNextReadAddr();
    }
}

