/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.model.EventPoster;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Int;
import bt747.sys.interfaces.BT747Time;
import gps.BT747Constants;
import gps.convert.Conv;
import gps.mvc.GpsLinkHandler;
import gps.mvc.GpsModel;
import gps.mvc.MTKLogDownloadHandler;
import gps.mvc.commands.CmdVisitor;
import gps.mvc.commands.GpsLinkExecCommand;
import gps.mvc.commands.GpsLinkNmeaCommand;
import net.sf.bt747.gps.mtk.MtkBinTransportMessageModel;
import net.sf.bt747.util.GpsConvert;

public class MtkModel
implements EventPoster {
    private final GpsLinkHandler handler;
    protected MTKLogDownloadHandler mtkLogHandler;
    private int logFormat = 0;
    protected int logTimeIntervalX100ms = 0;
    private int logSpeedInterval = 0;
    protected int logDistanceIntervalDm = 0;
    private int logStatus = 0;
    private int initialLogMode = 0;
    private int lastLogBlock = 0;
    public int logNbrLogPts = 0;
    private int logMemUsed = 0;
    public int logMemUsedPercent = 0;
    protected int logFixPeriod = 0;
    protected int datum = 0;
    private boolean loggingActive = false;
    public boolean loggerIsFull = false;
    private boolean loggerNeedsInit = false;
    private boolean loggerIsDisabled = false;
    protected boolean logFullOverwrite = false;
    protected int dgpsMode = 0;
    protected int dtUserOptionTimesLeft;
    protected int dtUpdateRate;
    protected int dtBaudRate;
    protected int dtGLL_Period;
    protected int dtRMC_Period;
    protected int dtVTG_Period;
    protected int dtGSA_Period;
    protected int dtGSV_Period;
    protected int dtGGA_Period;
    protected int dtZDA_Period;
    protected int dtMCHN_Period;
    protected String mainVersion = "";
    protected String model = "";
    protected String device = "";
    protected String firmwareVersion = "";
    private String MtkLogVersion = "";
    private int flashManuProdID = 0;
    protected String sBtMacAddr = "";
    protected final int[] NMEA_periods = new int[19];
    protected boolean holux = false;
    protected String holuxName = "";
    protected boolean SBASEnabled = false;
    protected boolean SBASTestEnabled = false;
    protected boolean powerSaveEnabled = false;
    private GpsModel context;
    protected boolean hasAgps = false;
    protected int agpsDataCount = 0;
    protected BT747Time agpsStartTime;
    protected BT747Time agpsEndTime;
    protected BT747Time agpsStart2Time;
    protected BT747Time agpsEnd2Time;
    protected int dataOK = 0;
    private final boolean[] dataAvailable = new boolean[27];
    private final boolean[] dataSupported = new boolean[27];
    private final int[] dataRequested = new int[27];
    private final boolean[] dataTimesOut = new boolean[]{false, true, true, false, false, false, false, true, false, true};
    private boolean autofetch = true;
    private boolean eraseOngoing = false;
    private int logDownloadEndAddr;
    private int nextReadAddr;
    private boolean isLogDownloadOngoing = false;

    protected final void setLogHandler(MTKLogDownloadHandler mTKLogDownloadHandler) {
        this.mtkLogHandler = mTKLogDownloadHandler;
    }

    public MtkModel(GpsModel gpsModel, GpsLinkHandler gpsLinkHandler) {
        this.handler = gpsLinkHandler;
        this.context = gpsModel;
    }

    public final boolean isDataOK(int n) {
        return (this.dataOK & n) == n;
    }

    protected final void setAllUnavailable() {
        int n = Generic.getTimeStamp() - 300000;
        for (int i = 0; i < this.dataAvailable.length; ++i) {
            this.dataAvailable[i] = false;
            this.dataRequested[i] = n;
            this.dataSupported[i] = true;
        }
        this.hasAgps = false;
        this.agpsDataCount = 0;
        this.agpsStartTime = null;
        this.agpsEndTime = null;
        this.agpsStart2Time = null;
        this.agpsEnd2Time = null;
    }

    protected final boolean isDataNeedsRequest(int n, int n2) {
        if (n2 > 9) {
            return true;
        }
        if (!this.autofetch) {
            return false;
        }
        if (!this.dataSupported[n2]) {
            return false;
        }
        if (Generic.getDebugLevel() > 3) {
            Generic.debug("ts:" + n + " type:" + n2 + " timesout:" + this.dataTimesOut[n2] + " available:" + this.dataAvailable[n2] + " requested:" + (n - this.dataRequested[n2]));
        }
        if ((this.autofetch && this.dataTimesOut[n2] || !this.isDataAvailable(n2)) && n - this.dataRequested[n2] > 3500) {
            this.dataRequested[n2] = n;
            return true;
        }
        return false;
    }

    protected final void setAvailable(int n) {
        this.setAvailable(n, true);
    }

    protected final void setUnAvailable(int n) {
        this.setAvailable(n, false);
    }

    protected final void setAvailable(int n, boolean bl) {
        this.dataAvailable[n] = bl;
        if (!bl) {
            return;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 3: {
                this.dataOK |= 0x200;
                break;
            }
            case 9: {
                this.dataRequested[9] = this.dataRequested[9] + 30000;
                break;
            }
        }
        this.postEvent(37, BT747Int.get(n));
    }

    public final boolean isDataAvailable(int n) {
        return this.dataAvailable[n];
    }

    protected final void setChanged(int n) {
        this.dataAvailable[n] = false;
        this.dataRequested[n] = 0;
    }

    public GpsLinkHandler getHandler() {
        return this.handler;
    }

    protected boolean analyseResponse(Object object) {
        if (object instanceof MtkBinTransportMessageModel) {
            return this.analyseMtkBinData((MtkBinTransportMessageModel)object);
        }
        if (object instanceof String[]) {
            if (!this.context.analyseNMEA((String[])object)) {
                return this.analyseMtkNmea((String[])object);
            }
            return true;
        }
        return false;
    }

    public final boolean analyseMtkBinData(MtkBinTransportMessageModel mtkBinTransportMessageModel) {
        if (Generic.isDebug()) {
            Generic.debug("<" + mtkBinTransportMessageModel.toString());
        }
        return true;
    }

    protected boolean analyseLogNmea(String[] stringArray) {
        this.handler.resetLogTimeOut();
        if (stringArray.length > 2) {
            block1 : switch (JavaLibBridge.toInt(stringArray[1])) {
                case 3: {
                    int n = JavaLibBridge.toInt(stringArray[2]);
                    if (stringArray.length != 4) break;
                    switch (n) {
                        case 1: {
                            this.mtkLogHandler.handleLogFlashStatReply(stringArray[3]);
                            break block1;
                        }
                        case 2: {
                            this.logFormat = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(3);
                            this.postEvent(2);
                            break block1;
                        }
                        case 3: {
                            this.logTimeIntervalX100ms = JavaLibBridge.toInt(stringArray[3]);
                            this.dataOK |= 0x40;
                            this.setAvailable(11);
                            this.postEvent(18);
                            break block1;
                        }
                        case 4: {
                            this.logDistanceIntervalDm = JavaLibBridge.toInt(stringArray[3]);
                            this.dataOK |= 0x100;
                            this.setAvailable(13);
                            this.postEvent(20);
                            break block1;
                        }
                        case 5: {
                            this.logSpeedInterval = JavaLibBridge.toInt(stringArray[3]) / 10;
                            this.dataOK |= 0x80;
                            this.setAvailable(12);
                            this.postEvent(19);
                            break block1;
                        }
                        case 6: {
                            this.logFullOverwrite = JavaLibBridge.toInt(stringArray[3]) == 1;
                            this.postEvent(27);
                            break block1;
                        }
                        case 7: {
                            this.logStatus = JavaLibBridge.toInt(stringArray[3]);
                            this.setLoggingActive((this.logStatus & 2) != 0);
                            this.loggerIsFull = (this.logStatus & 0x800) != 0;
                            this.loggerNeedsInit = (this.logStatus & 0x400) != 0;
                            this.loggerIsDisabled = (this.logStatus & 0x200) != 0 || (this.logStatus & 0x100) == 0;
                            this.setAvailable(7);
                            this.postEvent(28);
                            break block1;
                        }
                        case 8: {
                            this.setLogMemUsed(Conv.hex2Int(stringArray[3]));
                            break block1;
                        }
                        case 9: {
                            this.flashManuProdID = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(0);
                            this.postEvent(23);
                            break block1;
                        }
                        case 10: {
                            this.logNbrLogPts = Conv.hex2Int(stringArray[3]);
                            this.setAvailable(1);
                            this.postEvent(24);
                            break block1;
                        }
                        case 11: {
                            this.setAvailable(15);
                            this.postEvent(25);
                            break block1;
                        }
                        case 12: {
                            this.MtkLogVersion = "V" + JavaLibBridge.toString((float)JavaLibBridge.toInt(stringArray[3]) / 100.0f, 2);
                            this.setAvailable(8);
                            this.postEvent(26);
                            break block1;
                        }
                    }
                    break;
                }
                case 8: {
                    try {
                        if (Conv.hex2Int(stringArray[2]) == 6) {
                            this.initialLogMode = Conv.hex2Int(stringArray[3].substring(0, 4));
                            this.initialLogMode = this.initialLogMode & 0xFF00 | this.initialLogMode >> 8;
                            this.setAvailable(6);
                            break;
                        }
                        if (Conv.hex2Int(stringArray[2]) == (this.getLogMemSize() - 1 & 0xFFFF0000) + 6) {
                            this.lastLogBlock = Conv.hex2Int(stringArray[3].substring(0, 8));
                            this.setAvailable(9);
                            break;
                        }
                        this.mtkLogHandler.analyzeLogPart(Conv.hex2Int(stringArray[2]), stringArray[3]);
                    }
                    catch (Exception exception) {
                        Generic.debug("analyzeLogNMEA", exception);
                    }
                    break;
                }
            }
        }
        return true;
    }

    public boolean analyseMtkNmea(String[] stringArray) {
        boolean bl;
        block42: {
            block41: {
                bl = false;
                if (stringArray == null || stringArray.length <= 0) {
                    return bl;
                }
                if (!stringArray[0].startsWith("PMTK")) break block41;
                bl = true;
                if (Generic.isDebug()) {
                    int n = stringArray.length;
                    if (stringArray[1].length() > 0 && stringArray[1].charAt(0) == '8') {
                        n = 3;
                    }
                    StringBuffer stringBuffer = new StringBuffer(60);
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(',');
                    }
                    Generic.debug(stringBuffer.toString());
                }
                int n = JavaLibBridge.toInt(stringArray[0].substring(4));
                bl = false;
                switch (n) {
                    case 182: {
                        bl = this.analyseLogNmea(stringArray);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = this.analyseMTK_Ack(stringArray);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 500: {
                        if (stringArray.length >= 2) {
                            this.logFixPeriod = JavaLibBridge.toInt(stringArray[1]);
                            this.setAvailable(16);
                            this.postEvent(13);
                        }
                        this.dataOK |= 1;
                        break;
                    }
                    case 501: {
                        if (stringArray.length == 2) {
                            this.dgpsMode = JavaLibBridge.toInt(stringArray[1]);
                        }
                        this.dataOK |= 2;
                        this.postEvent(29);
                        break;
                    }
                    case 513: {
                        if (stringArray.length == 2) {
                            this.SBASEnabled = stringArray[1].equals("1");
                        }
                        this.dataOK |= 4;
                        this.postEvent(30);
                        break;
                    }
                    case 514: {
                        if (stringArray.length - 1 == 19) {
                            for (int i = 0; i < 19; ++i) {
                                this.NMEA_periods[i] = JavaLibBridge.toInt(stringArray[i + 1]);
                            }
                        }
                        this.dataOK |= 8;
                        this.postEvent(15);
                        break;
                    }
                    case 519: {
                        if (stringArray.length == 2) {
                            this.SBASTestEnabled = stringArray[1].equals("0");
                        }
                        this.dataOK |= 0x10;
                        this.postEvent(31);
                        break;
                    }
                    case 520: {
                        if (stringArray.length == 2) {
                            this.powerSaveEnabled = stringArray[1].equals("1");
                        }
                        this.postEvent(32);
                        break;
                    }
                    case 530: {
                        if (stringArray.length == 2) {
                            this.datum = JavaLibBridge.toInt(stringArray[1]);
                        }
                        this.dataOK |= 0x20;
                        this.postEvent(33);
                        break;
                    }
                    case 590: {
                        this.dtUserOptionTimesLeft = JavaLibBridge.toInt(stringArray[1]);
                        this.dtUpdateRate = JavaLibBridge.toInt(stringArray[2]);
                        this.dtBaudRate = JavaLibBridge.toInt(stringArray[3]);
                        this.dtGLL_Period = JavaLibBridge.toInt(stringArray[4]);
                        this.dtRMC_Period = JavaLibBridge.toInt(stringArray[5]);
                        this.dtVTG_Period = JavaLibBridge.toInt(stringArray[6]);
                        this.dtGSA_Period = JavaLibBridge.toInt(stringArray[7]);
                        this.dtGSV_Period = JavaLibBridge.toInt(stringArray[8]);
                        this.dtGGA_Period = JavaLibBridge.toInt(stringArray[9]);
                        this.dtZDA_Period = JavaLibBridge.toInt(stringArray[10]);
                        this.dtMCHN_Period = JavaLibBridge.toInt(stringArray[11]);
                        this.postEvent(16);
                        break;
                    }
                    case 592: {
                        if (stringArray[1].length() == 12) {
                            this.sBtMacAddr = stringArray[1].substring(10, 12) + ":" + stringArray[1].substring(8, 10) + ":" + stringArray[1].substring(6, 8) + ":" + stringArray[1].substring(4, 6) + ":" + stringArray[1].substring(2, 4) + ":" + stringArray[1].substring(0, 2);
                        }
                        this.postEvent(34);
                        break;
                    }
                    case 702: {
                        break;
                    }
                    case 704: {
                        this.mainVersion = stringArray[1] + "." + stringArray[2] + "." + stringArray[3];
                        this.setAvailable(4);
                        this.postEvent(35);
                        break;
                    }
                    case 705: {
                        this.firmwareVersion = stringArray[1];
                        this.model = stringArray[2];
                        if (stringArray.length >= 4) {
                            this.device = stringArray[3];
                            this.firmwareVersion = this.firmwareVersion + " (" + this.device + ")";
                        } else {
                            this.device = "";
                        }
                        this.setAvailable(5);
                        this.postEvent(36);
                        break;
                    }
                    case 707: {
                        if (stringArray.length >= 10) {
                            this.hasAgps = true;
                            this.agpsDataCount = JavaLibBridge.toInt(stringArray[1]);
                            this.agpsStartTime = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[2]), JavaLibBridge.toInt(stringArray[3]));
                            this.agpsEndTime = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[4]), JavaLibBridge.toInt(stringArray[5]));
                            this.agpsStart2Time = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[6]), JavaLibBridge.toInt(stringArray[7]));
                            this.agpsEnd2Time = GpsConvert.toTime(JavaLibBridge.toInt(stringArray[8]), JavaLibBridge.toInt(stringArray[9]));
                            this.setAvailable(17);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block42;
            }
            if (stringArray[0].equals("HOLUX001")) {
                this.holux = true;
                bl = false;
                if (Generic.isDebug()) {
                    int n = stringArray.length;
                    StringBuffer stringBuffer = new StringBuffer(60);
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append(',');
                    }
                    Generic.debug(stringBuffer.toString());
                }
                int n = JavaLibBridge.toInt(stringArray[1]);
                bl = false;
                switch (n) {
                    case 5: {
                        if (stringArray.length != 3) break;
                        this.holuxName = stringArray[2];
                        this.postEvent(17);
                        break;
                    }
                }
            }
        }
        return bl;
    }

    protected boolean analyseMTK_Ack(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length >= 3) {
            int n = JavaLibBridge.toInt(stringArray[stringArray.length - 1]);
            int n2 = JavaLibBridge.toInt(stringArray[1]);
            StringBuffer stringBuffer = new StringBuffer("PMTK");
            stringBuffer.append(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(stringArray[i]);
            }
            this.handler.removeFromSentCmds(new MtkVisitor(stringBuffer.toString()));
            switch (n) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    switch (n2) {
                        case 604: {
                            this.dataSupported[4] = false;
                        }
                    }
                    bl = true;
                    break;
                }
                case 2: {
                    bl = true;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected final void postEvent(int n) {
        this.context.postGpsEvent(n, null);
    }

    protected final void postEvent(int n, Object object) {
        this.context.postGpsEvent(n, object);
    }

    public void postEvent(ModelEvent modelEvent) {
        this.context.postEvent(modelEvent);
    }

    public final int logMemUsefullSize() {
        return (this.getLogMemSize() >> 16) * 65024;
    }

    public final int logFreeMemUsefullSize() {
        return this.getLogMemSize() - this.getLogMemUsed() - (this.getLogMemSize() - this.getLogMemUsed() >> 16) * 512;
    }

    public final String getBtMacAddr() {
        return this.sBtMacAddr;
    }

    public final int getFlashManuProdID() {
        return this.flashManuProdID;
    }

    public final String getFlashDesc() {
        return BT747Constants.getFlashDesc(this.flashManuProdID);
    }

    public final String getMtkLogVersion() {
        return this.MtkLogVersion;
    }

    public final boolean isHolux() {
        return this.holux;
    }

    public final String getHoluxName() {
        return this.holuxName;
    }

    public final int getLogFormat() {
        return this.logFormat;
    }

    public final int getDtUpdateRate() {
        return this.dtUpdateRate;
    }

    public final int getDtGLL_Period() {
        return this.dtGLL_Period;
    }

    public final int getDtRMC_Period() {
        return this.dtRMC_Period;
    }

    public final int getDtVTG_Period() {
        return this.dtVTG_Period;
    }

    public final int getDtGSA_Period() {
        return this.dtGSA_Period;
    }

    public final int getDtGSV_Period() {
        return this.dtGSV_Period;
    }

    public final int getDtGGA_Period() {
        return this.dtGGA_Period;
    }

    public final int getDtZDA_Period() {
        return this.dtZDA_Period;
    }

    public final int getDtMCHN_Period() {
        return this.dtMCHN_Period;
    }

    public final int getDtBaudRate() {
        return this.dtBaudRate;
    }

    public final int getDtUserOptionTimesLeft() {
        return this.dtUserOptionTimesLeft;
    }

    public final int getLogTimeInterval() {
        return this.logTimeIntervalX100ms;
    }

    public final int getLogSpeedInterval() {
        return this.logSpeedInterval;
    }

    public final int getLogDistanceInterval() {
        return this.logDistanceIntervalDm;
    }

    public final int getLogFixPeriod() {
        return this.logFixPeriod;
    }

    public final boolean isSBASEnabled() {
        return this.SBASEnabled;
    }

    public final boolean isSBASTestEnabled() {
        return this.SBASTestEnabled;
    }

    public final boolean isInitialLogOverwrite() {
        return (this.initialLogMode & 4) == 0 && this.lastLogBlock != -1;
    }

    public final int getDgpsMode() {
        return this.dgpsMode;
    }

    protected void setLoggingActive(boolean bl) {
        this.loggingActive = bl;
    }

    public final boolean isLogFullOverwrite() {
        return this.logFullOverwrite;
    }

    public final int getDatum() {
        return this.datum;
    }

    public final int getNMEAPeriod(int n) {
        return this.NMEA_periods[n];
    }

    protected final boolean isEraseOngoing() {
        return this.eraseOngoing;
    }

    protected final void setEraseOngoing(boolean bl) {
        if (this.eraseOngoing != bl) {
            this.eraseOngoing = bl;
            if (bl) {
                this.postEvent(9);
            } else {
                this.postEvent(10);
                this.handler.setEraseOngoing(false);
            }
        }
    }

    public final boolean isLoggingActive() {
        return this.loggingActive;
    }

    public final boolean isLoggingDisabled() {
        return this.loggerIsDisabled;
    }

    public final String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public final String getMainVersion() {
        return this.mainVersion;
    }

    public final int getLogMemSize() {
        return BT747Constants.getFlashSize(this.flashManuProdID);
    }

    protected void setLogMemUsed(int n) {
        this.logMemUsed = n;
        this.logMemUsedPercent = 100 * (this.getLogMemUsed() - 512 * ((this.getLogMemUsed() + 65535) / 65536)) / this.logMemUsefullSize();
        this.setAvailable(2);
        this.postEvent(22);
    }

    public final int getLogMemUsed() {
        return this.logMemUsed;
    }

    private final String modelName() {
        return BT747Constants.modelName(Conv.hex2Int(this.model), this.device);
    }

    public final String getModel() {
        return this.model.length() != 0 ? this.model + " (" + this.modelName() + ')' : "";
    }

    public final int getStartAddr() {
        return this.mtkLogHandler.getStartAddr();
    }

    public final int getEndAddr() {
        return this.logDownloadEndAddr;
    }

    protected void setEndAddr(int n) {
        this.logDownloadEndAddr = n;
    }

    protected void setNextReadAddr(int n) {
        this.nextReadAddr = n;
    }

    public final int getNextReadAddr() {
        return this.nextReadAddr;
    }

    public final boolean isLogDownloadOngoing() {
        return this.isLogDownloadOngoing;
    }

    protected final void setLogDownloadOngoing(boolean bl) {
        this.isLogDownloadOngoing = bl;
    }

    private static final class MtkVisitor
    implements CmdVisitor {
        private final String cmd;

        public MtkVisitor(String string) {
            this.cmd = string;
        }

        public boolean isAcknowledgeOf(GpsLinkExecCommand gpsLinkExecCommand) {
            if (gpsLinkExecCommand instanceof GpsLinkNmeaCommand) {
                return ((GpsLinkNmeaCommand)gpsLinkExecCommand).getNmeaValue().startsWith(this.cmd);
            }
            return false;
        }
    }
}

