/*
 * Decompiled with CFR 0.152.
 */
package gps.tracks;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Vector;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class PolylineEncoder {
    private final int numLevels;
    private final int zoomFactor;
    private final float verySmall;
    private final boolean forceEndpoints;
    private final float[] zoomLevelBreaks;
    private BT747Hashtable bounds;

    public PolylineEncoder() {
        this.numLevels = 18;
        this.zoomFactor = 2;
        this.verySmall = 1.0E-5f;
        this.forceEndpoints = true;
        this.zoomLevelBreaks = new float[this.numLevels];
        for (int i = 0; i < this.numLevels; ++i) {
            this.zoomLevelBreaks[i] = (float)((double)this.verySmall * Generic.pow(this.zoomFactor, this.numLevels - i - 1));
        }
    }

    public final BT747Hashtable dpEncode(Track track) {
        Object object;
        BT747Vector bT747Vector = JavaLibBridge.getVectorInstance();
        float[] fArray = new float[track.getTrackpoints().size()];
        float f = 0.0f;
        BT747Vector bT747Vector2 = track.getTrackpoints();
        if (bT747Vector2.size() > 2) {
            object = new int[]{0, bT747Vector2.size() - 1};
            bT747Vector.mypush(object);
            while (bT747Vector.size() > 0) {
                int[] nArray = (int[])bT747Vector.pop();
                int n = nArray[0];
                int n2 = nArray[1];
                float f2 = 0.0f;
                int n3 = 0;
                for (int i = n + 1; i < n2; ++i) {
                    float f3 = (float)PolylineEncoder.distance((Trackpoint)bT747Vector2.elementAt(i), (Trackpoint)bT747Vector2.elementAt(n), (Trackpoint)track.getTrackpoints().elementAt(n2));
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                    n3 = i;
                    if (!(f2 > f)) continue;
                    f = f2;
                }
                if (!(f2 > this.verySmall)) continue;
                fArray[n3] = f2;
                int[] nArray2 = new int[]{n, n3};
                bT747Vector.mypush(nArray2);
                int[] nArray3 = new int[]{n3, n2};
                bT747Vector.mypush(nArray3);
            }
        }
        String string = this.createEncodings(track, fArray);
        string = PolylineEncoder.replace(string, "\\", "\\\\");
        String string2 = this.encodeLevels(track, fArray, f);
        object = JavaLibBridge.getHashtableInstance(0);
        object.put("encodedPoints", string);
        object.put("encodedLevels", string2);
        return object;
    }

    public static final String replace(String string, String string2, String string3) {
        if (string.equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(string2, 0);
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
            n = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static final double distance(Trackpoint trackpoint, Trackpoint trackpoint2, Trackpoint trackpoint3) {
        double d;
        double d2 = 0.0;
        d2 = trackpoint2.getLatDouble() == trackpoint3.getLatDouble() && trackpoint2.getLonDouble() == trackpoint3.getLonDouble() ? Math.sqrt(Generic.pow(trackpoint3.getLatDouble() - trackpoint.getLatDouble(), 2.0) + Generic.pow(trackpoint3.getLonDouble() - trackpoint.getLonDouble(), 2.0)) : ((d = ((trackpoint.getLatDouble() - trackpoint2.getLatDouble()) * (trackpoint3.getLatDouble() - trackpoint2.getLatDouble()) + (trackpoint.getLonDouble() - trackpoint2.getLonDouble()) * (trackpoint3.getLonDouble() - trackpoint2.getLonDouble())) / (Generic.pow(trackpoint3.getLatDouble() - trackpoint2.getLatDouble(), 2.0) + Generic.pow(trackpoint3.getLonDouble() - trackpoint2.getLonDouble(), 2.0))) <= 0.0 ? Math.sqrt(Generic.pow(trackpoint.getLatDouble() - trackpoint2.getLatDouble(), 2.0) + Generic.pow(trackpoint.getLonDouble() - trackpoint2.getLonDouble(), 2.0)) : (d < 1.0 ? Math.sqrt(Generic.pow(trackpoint.getLatDouble() - trackpoint2.getLatDouble() - d * (trackpoint3.getLatDouble() - trackpoint2.getLatDouble()), 2.0) + Generic.pow(trackpoint.getLonDouble() - trackpoint2.getLonDouble() - d * (trackpoint3.getLonDouble() - trackpoint2.getLonDouble()), 2.0)) : Math.sqrt(Generic.pow(trackpoint.getLatDouble() - trackpoint3.getLatDouble(), 2.0) + Generic.pow(trackpoint.getLonDouble() - trackpoint3.getLonDouble(), 2.0))));
        return d2;
    }

    private static final int floor1e5(double d) {
        return (int)Math.floor(d * 100000.0);
    }

    private static final String encodeSignedNumber(int n) {
        int n2 = n << 1;
        if (n < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return PolylineEncoder.encodeNumber(n2);
    }

    private static final String encodeNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 32; i >>= 5) {
            int n2 = (0x20 | i & 0x1F) + 63;
            stringBuffer.append((char)n2);
        }
        stringBuffer.append((char)(i += 63));
        return stringBuffer.toString();
    }

    private final String encodeLevels(Track track, float[] fArray, float f) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.forceEndpoints) {
            stringBuffer.append(PolylineEncoder.encodeNumber(this.numLevels - 1));
        } else {
            stringBuffer.append(PolylineEncoder.encodeNumber(this.numLevels - this.computeLevel(f) - 1));
        }
        for (int i = 1; i < track.size() - 1; ++i) {
            if (fArray[i] == 0.0f) continue;
            stringBuffer.append(PolylineEncoder.encodeNumber(this.numLevels - this.computeLevel(fArray[i]) - 1));
        }
        if (track.size() > 1) {
            if (this.forceEndpoints) {
                stringBuffer.append(PolylineEncoder.encodeNumber(this.numLevels - 1));
            } else {
                stringBuffer.append(PolylineEncoder.encodeNumber(this.numLevels - this.computeLevel(f) - 1));
            }
        }
        return stringBuffer.toString();
    }

    private int computeLevel(float f) {
        int n = 0;
        if (f > this.verySmall) {
            n = 0;
            while (f < this.zoomLevelBreaks[n]) {
                ++n;
            }
        }
        return n;
    }

    private String createEncodings(Track track, float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < track.size(); ++i) {
            if (i == 0) {
                d = d2 = track.get(i).getLatDouble();
                d3 = d4 = track.get(i).getLonDouble();
            } else if (track.get(i).getLatDouble() > d) {
                d = track.get(i).getLatDouble();
            } else if (track.get(i).getLatDouble() < d2) {
                d2 = track.get(i).getLatDouble();
            } else if (track.get(i).getLonDouble() > d3) {
                d3 = track.get(i).getLonDouble();
            } else if (track.get(i).getLonDouble() < d4) {
                d4 = track.get(i).getLonDouble();
            }
            if (fArray[i] == 0.0f && i != 0 && i != track.size() - 1) continue;
            Trackpoint trackpoint = track.get(i);
            int n3 = PolylineEncoder.floor1e5(trackpoint.getLatDouble());
            int n4 = PolylineEncoder.floor1e5(trackpoint.getLonDouble());
            int n5 = n3 - n;
            int n6 = n4 - n2;
            n = n3;
            n2 = n4;
            stringBuffer.append(PolylineEncoder.encodeSignedNumber(n5));
            stringBuffer.append(PolylineEncoder.encodeSignedNumber(n6));
        }
        BT747Hashtable bT747Hashtable = JavaLibBridge.getHashtableInstance(0);
        bT747Hashtable.put("maxlat", JavaLibBridge.toString(d));
        bT747Hashtable.put("minlat", JavaLibBridge.toString(d2));
        bT747Hashtable.put("maxlon", JavaLibBridge.toString(d3));
        bT747Hashtable.put("minlon", JavaLibBridge.toString(d4));
        this.setBounds(bT747Hashtable);
        return stringBuffer.toString();
    }

    private final void setBounds(BT747Hashtable bT747Hashtable) {
        this.bounds = bT747Hashtable;
    }
}

