/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractList;
import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.Collection;
import moio.util.Comparable;
import moio.util.Comparator;
import moio.util.Iterator;
import moio.util.List;
import moio.util.Map;
import moio.util.RandomAccess;
import moio.util.Serializable;
import moio.util.Set;
import waba.util.Random;

public class Collections {
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private Collections() {
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        SynchronizedSet(Object object, Set set) {
            super(object, set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        SynchronizedIterator(Object object, Iterator iterator) {
            this.i = iterator;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Object object, Collection collection) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object2).compareTo(object);
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        EmptyMap() {
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Object remove(Object object) {
            return null;
        }

        public int size() {
            return 0;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        EmptyList() {
        }

        public int size() {
            return 0;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        public int hashCode() {
            return 1;
        }

        public int indexOf(Object object) {
            return -1;
        }

        public boolean remove(Object object) {
            return false;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        EmptySet() {
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof Set && ((Set)object).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public boolean remove(Object object) {
            return false;
        }

        public String toString() {
            return "[]";
        }
    }
}

