/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.Arrays;
import org.openide.util.Exceptions;

final class IntMap {
    private int[] keys = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    private Object[] vals = new Object[4];
    private int last = -1;

    IntMap() {
    }

    public int first() {
        return this.isEmpty() ? -1 : this.keys[0];
    }

    public int nearest(int n, boolean bl) {
        if (this.isEmpty()) {
            return -1;
        }
        if (this.last == 0) {
            return this.keys[this.last];
        }
        if (n < this.keys[0]) {
            return bl ? this.keys[this.last] : this.keys[0];
        }
        if (n > this.keys[this.last]) {
            return bl ? this.keys[this.last] : this.keys[0];
        }
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 < 0) {
            if ((n2 = -n2 + (bl ? -2 : -1)) > this.last) {
                n2 = bl ? this.last : 0;
            } else if (n2 < 0) {
                n2 = bl ? this.last : 0;
            }
        }
        return this.keys[n2];
    }

    public int[] getKeys() {
        if (this.last == -1) {
            return new int[0];
        }
        if (this.last == this.keys.length - 1) {
            this.growArrays();
        }
        int[] nArray = new int[this.last + 1];
        try {
            System.arraycopy(this.keys, 0, nArray, 0, this.last + 1);
            return nArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = new ArrayIndexOutOfBoundsException("AIOOBE in IntMap.getKeys() - last = " + this.last + " keys: " + IntMap.i2s(this.keys) + " vals: " + Arrays.asList(this.vals) + " result length " + nArray.length);
            Exceptions.printStackTrace((Throwable)arrayIndexOutOfBoundsException2);
            return new int[0];
        }
    }

    private static String i2s(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3);
        stringBuffer.append('[');
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == Integer.MAX_VALUE) continue;
            stringBuffer.append(nArray[i]);
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Object get(int n) {
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 > -1 && n2 <= this.last) {
            return this.vals[n2];
        }
        return null;
    }

    public void put(int n, Object object) {
        if (this.last >= 0) {
            if (this.keys[this.last] == n && this.vals[this.last] == object) {
                return;
            }
            assert (n > this.keys[this.last]) : "key=" + n + " last=" + this.keys[this.last];
        }
        if (this.last == this.keys.length - 1) {
            this.growArrays();
        }
        ++this.last;
        this.keys[this.last] = n;
        this.vals[this.last] = object;
    }

    private void growArrays() {
        int n = this.keys.length * 2;
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        Arrays.fill(nArray, Integer.MAX_VALUE);
        System.arraycopy(this.keys, 0, nArray, 0, this.keys.length);
        System.arraycopy(this.vals, 0, objectArray, 0, this.vals.length);
        this.keys = nArray;
        this.vals = objectArray;
    }

    public int nextEntry(int n) {
        int n2;
        int n3 = -1;
        if (!this.isEmpty() && (n2 = Arrays.binarySearch(this.keys, n)) >= 0) {
            n3 = n2 == this.keys.length - 1 ? this.keys[0] : this.keys[n2 + 1];
        }
        return n3;
    }

    public int prevEntry(int n) {
        int n2;
        int n3 = -1;
        if (!this.isEmpty() && (n2 = Arrays.binarySearch(this.keys, n)) >= 0) {
            n3 = n2 == -1 ? this.keys[this.keys.length - 1] : this.keys[n2 - 1];
        }
        return n3;
    }

    public boolean isEmpty() {
        return this.last == -1;
    }

    public int size() {
        return this.last + 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IntMap@").append(System.identityHashCode(this));
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append("[");
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(":");
            stringBuffer.append(this.vals[i]);
            stringBuffer.append("]");
        }
        if (this.size() == 0) {
            stringBuffer.append("empty");
        }
        return stringBuffer.toString();
    }

    public void decrementKeys(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        for (int i = n2; i <= this.last; ++i) {
            this.keys[i - n2] = this.keys[i] - n;
            this.vals[i - n2] = this.vals[i];
        }
        Arrays.fill(this.keys, this.last - n2 + 1, this.last + 1, Integer.MAX_VALUE);
        this.last -= n2;
    }
}

