/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Map;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IInvokedMethodListener2;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Maps;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.invokers.InvokedMethodListenerSubtype;

public class InvokedMethodListenerInvoker {
    private InvokedMethodListenerMethod m_listenerMethod;
    private ITestContext m_testContext;
    private ITestResult m_testResult;
    private static final Map<InvokedMethodListenerSubtype, Map<InvokedMethodListenerMethod, InvocationStrategy>> strategies = Maps.newHashMap();
    private static final Map<InvokedMethodListenerMethod, InvocationStrategy> INVOKE_WITH_CONTEXT_STRATEGIES = Maps.newHashMap();
    private static final Map<InvokedMethodListenerMethod, InvocationStrategy> INVOKE_WITHOUT_CONTEXT_STRATEGIES = Maps.newHashMap();

    public InvokedMethodListenerInvoker(InvokedMethodListenerMethod invokedMethodListenerMethod, ITestResult iTestResult, ITestContext iTestContext) {
        this.m_listenerMethod = invokedMethodListenerMethod;
        this.m_testContext = iTestContext;
        this.m_testResult = iTestResult;
    }

    public void invokeListener(IInvokedMethodListener iInvokedMethodListener, IInvokedMethod iInvokedMethod) {
        InvocationStrategy invocationStrategy = this.obtainStrategyFor(iInvokedMethodListener, this.m_listenerMethod);
        invocationStrategy.callMethod(iInvokedMethodListener, iInvokedMethod, this.m_testResult, this.m_testContext);
    }

    private InvocationStrategy obtainStrategyFor(IInvokedMethodListener iInvokedMethodListener, InvokedMethodListenerMethod invokedMethodListenerMethod) {
        InvokedMethodListenerSubtype invokedMethodListenerSubtype = InvokedMethodListenerSubtype.fromListener(iInvokedMethodListener);
        Map<InvokedMethodListenerMethod, InvocationStrategy> map = strategies.get((Object)invokedMethodListenerSubtype);
        InvocationStrategy invocationStrategy = map.get((Object)invokedMethodListenerMethod);
        return invocationStrategy;
    }

    static {
        INVOKE_WITH_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.BEFORE_INVOCATION, new InvokeBeforeInvocationWithContextStrategy());
        INVOKE_WITH_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.AFTER_INVOCATION, new InvokeAfterInvocationWithContextStrategy());
        INVOKE_WITHOUT_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.BEFORE_INVOCATION, new InvokeBeforeInvocationWithoutContextStrategy());
        INVOKE_WITHOUT_CONTEXT_STRATEGIES.put(InvokedMethodListenerMethod.AFTER_INVOCATION, new InvokeAfterInvocationWithoutContextStrategy());
        strategies.put(InvokedMethodListenerSubtype.EXTENDED_LISTENER, INVOKE_WITH_CONTEXT_STRATEGIES);
        strategies.put(InvokedMethodListenerSubtype.SIMPLE_LISTENER, INVOKE_WITHOUT_CONTEXT_STRATEGIES);
    }

    private static class InvokeAfterInvocationWithContextStrategy
    implements InvocationStrategy<IInvokedMethodListener2> {
        private InvokeAfterInvocationWithContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener2 iInvokedMethodListener2, IInvokedMethod iInvokedMethod, ITestResult iTestResult, ITestContext iTestContext) {
            iInvokedMethodListener2.afterInvocation(iInvokedMethod, iTestResult, iTestContext);
        }
    }

    private static class InvokeAfterInvocationWithoutContextStrategy
    implements InvocationStrategy<IInvokedMethodListener> {
        private InvokeAfterInvocationWithoutContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener iInvokedMethodListener, IInvokedMethod iInvokedMethod, ITestResult iTestResult, ITestContext iTestContext) {
            iInvokedMethodListener.afterInvocation(iInvokedMethod, iTestResult);
        }
    }

    private static class InvokeBeforeInvocationWithContextStrategy
    implements InvocationStrategy<IInvokedMethodListener2> {
        private InvokeBeforeInvocationWithContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener2 iInvokedMethodListener2, IInvokedMethod iInvokedMethod, ITestResult iTestResult, ITestContext iTestContext) {
            iInvokedMethodListener2.beforeInvocation(iInvokedMethod, iTestResult, iTestContext);
        }
    }

    private static class InvokeBeforeInvocationWithoutContextStrategy
    implements InvocationStrategy<IInvokedMethodListener> {
        private InvokeBeforeInvocationWithoutContextStrategy() {
        }

        @Override
        public void callMethod(IInvokedMethodListener iInvokedMethodListener, IInvokedMethod iInvokedMethod, ITestResult iTestResult, ITestContext iTestContext) {
            iInvokedMethodListener.beforeInvocation(iInvokedMethod, iTestResult);
        }
    }

    private static interface InvocationStrategy<LISTENER_TYPE extends IInvokedMethodListener> {
        public void callMethod(LISTENER_TYPE var1, IInvokedMethod var2, ITestResult var3, ITestContext var4);
    }
}

