/* mcnBreakpoints.h was originally generated by the autoSql program, which also 
 * generated mcnBreakpoints.c and mcnBreakpoints.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MCNBREAKPOINTS_H
#define MCNBREAKPOINTS_H

struct mcnBreakpoints
/* Chromosomal breakpoints from the MCN Project */
    {
    struct mcnBreakpoints *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome number */
    unsigned chromStart;	/* Start position in genoSeq */
    unsigned chromEnd;	/* End position in genoSeq */
    char *name;	/* Shortened Traitgroup Name */
    unsigned score;	/* Always 1000 for now */
    char *caseId;	/* MCN Case ID */
    char *bpId;	/* MCN Breakpoint ID */
    char *trId;	/* MCN Trait ID */
    char *trTxt;	/* MCN Trait name */
    char *tgId;	/* MCN Traitgroup ID */
    char *tgTxt;	/* MCN Traitgroup Name */
    };

void mcnBreakpointsStaticLoad(char **row, struct mcnBreakpoints *ret);
/* Load a row from mcnBreakpoints table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct mcnBreakpoints *mcnBreakpointsLoad(char **row);
/* Load a mcnBreakpoints from row fetched with select * from mcnBreakpoints
 * from database.  Dispose of this with mcnBreakpointsFree(). */

struct mcnBreakpoints *mcnBreakpointsLoadAll(char *fileName);
/* Load all mcnBreakpoints from a tab-separated file.
 * Dispose of this with mcnBreakpointsFreeList(). */

struct mcnBreakpoints *mcnBreakpointsCommaIn(char **pS, struct mcnBreakpoints *ret);
/* Create a mcnBreakpoints out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mcnBreakpoints */

void mcnBreakpointsFree(struct mcnBreakpoints **pEl);
/* Free a single dynamically allocated mcnBreakpoints such as created
 * with mcnBreakpointsLoad(). */

void mcnBreakpointsFreeList(struct mcnBreakpoints **pList);
/* Free a list of dynamically allocated mcnBreakpoints's */

void mcnBreakpointsOutput(struct mcnBreakpoints *el, FILE *f, char sep, char lastSep);
/* Print out mcnBreakpoints.  Separate fields with sep. Follow last field with lastSep. */

#define mcnBreakpointsTabOut(el,f) mcnBreakpointsOutput(el,f,'\t','\n');
/* Print out mcnBreakpoints as a line in a tab-separated file. */

#define mcnBreakpointsCommaOut(el,f) mcnBreakpointsOutput(el,f,',',',');
/* Print out mcnBreakpoints as a comma separated list including final comma. */

#endif /* MCNBREAKPOINTS_H */

