/* switchDbTss.h was originally generated by the autoSql program, which also 
 * generated switchDbTss.c and switchDbTss.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SWITCHDBTSS_H
#define SWITCHDBTSS_H

#define SWITCHDBTSS_NUM_COLS 11

struct switchDbTss
/* Switchgear Genomics TSS DB table */
    {
    struct switchDbTss *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start in Chromosome */
    unsigned chromEnd;	/* End in Chromosome */
    char *name;	/* Name */
    unsigned score;	/* Score */
    char strand[2];	/* Strand */
    double confScore;	/* Confidence score */
    char *gmName;	/* Gene model UID/name */
    unsigned gmChromStart;	/* Gene model chromStart */
    unsigned gmChromEnd;	/* Gene model chromEnd */
    unsigned char isPseudo;	/* 0 if not a pseudogene TSS, 1 if it is */
    };

void switchDbTssStaticLoad(char **row, struct switchDbTss *ret);
/* Load a row from switchDbTss table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct switchDbTss *switchDbTssLoad(char **row);
/* Load a switchDbTss from row fetched with select * from switchDbTss
 * from database.  Dispose of this with switchDbTssFree(). */

struct switchDbTss *switchDbTssLoadAll(char *fileName);
/* Load all switchDbTss from whitespace-separated file.
 * Dispose of this with switchDbTssFreeList(). */

struct switchDbTss *switchDbTssLoadAllByChar(char *fileName, char chopper);
/* Load all switchDbTss from chopper separated file.
 * Dispose of this with switchDbTssFreeList(). */

#define switchDbTssLoadAllByTab(a) switchDbTssLoadAllByChar(a, '\t');
/* Load all switchDbTss from tab separated file.
 * Dispose of this with switchDbTssFreeList(). */

struct switchDbTss *switchDbTssCommaIn(char **pS, struct switchDbTss *ret);
/* Create a switchDbTss out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new switchDbTss */

void switchDbTssFree(struct switchDbTss **pEl);
/* Free a single dynamically allocated switchDbTss such as created
 * with switchDbTssLoad(). */

void switchDbTssFreeList(struct switchDbTss **pList);
/* Free a list of dynamically allocated switchDbTss's */

void switchDbTssOutput(struct switchDbTss *el, FILE *f, char sep, char lastSep);
/* Print out switchDbTss.  Separate fields with sep. Follow last field with lastSep. */

#define switchDbTssTabOut(el,f) switchDbTssOutput(el,f,'\t','\n');
/* Print out switchDbTss as a line in a tab-separated file. */

#define switchDbTssCommaOut(el,f) switchDbTssOutput(el,f,',',',');
/* Print out switchDbTss as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* SWITCHDBTSS_H */

