table retroMrnaInfo
"Retrogenes based on cDNA alignments that are expressed or processed pseudogenes."
    (
    string chrom;	"Reference sequence chromosome or scaffold col1"
    uint chromStart;	"pseudogene alignment start position col2"
    uint chromEnd;      "pseudogene alignment end position col3"
    string name;        "Name of pseudogene col4"
    uint score;         "score of pseudogene with gene col5"
    char[2] strand;     "+ or -"
    uint thickStart;    "Start of where display should be thick (start codon)"
    uint thickEnd;      "End of where display should be thick (stop codon)"
    uint reserved;      "Always zero for now"
    int blockCount;     "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    int retroExonCount;	"number of exons in retroGene col13"
    int axtScore;       "blastz score, parent mrna aligned to pseudogene col14"
    string type;	"type of evidence col15"
    string gChrom;	"Chromosome name col16"
    int gStart;	        "gene alignment start position col17"
    int gEnd;           "gene alignment end position col18"
    char[2] gStrand;    "strand of gene col19"
    uint parentSpliceCount;     "# of splice sites in parent gene col20"
    uint geneOverlap;   "bases overlapping col21"
    uint polyA;         "count of As in polyA col22"
    int polyAstart;     "start of polyA, relative to end of pseudogene col23"
    int exonCover;      "number of exons in Gene covered col24"
    uint intronCount;   "number of introns in pseudogene col25"
    uint bestAliCount;  "number of good mrnas aligning col26"
    uint matches;       "matches + repMatches col27"
    uint qSize;         "aligning bases in pseudogene col28"
    uint qEnd;          "end of cdna alignment col29"
    uint tReps;         "repeats in gene col30"
    int overlapRhesus;  "percent of retro that breaks net relative to Rhesus col31" 
    int overlapMouse;   "percent of retro that breaks net relative to Mouse col32"
    uint coverage;      "% of bases that align to gene col33"
    int label;          "1=pseudogene,-1 not pseudogene -2 expressed retroGene col34"
    uint milliBad;      "milliBad score, pseudogene aligned to genome col35"
    uint oldScore;      "another heuristic col36"
    int oldIntronCount; "old simple intron count col37"
    int processedIntrons; "count of introns removed via retrotransposition col38"
    int conservedSpliceSites; "conserved splice site count col39"
    int maxOverlap ;    "largest overlap with another mrna col40"
    string refSeq;	"Name of closest regSeq to gene col41"
    int rStart;	        "refSeq alignment start position col42"
    int rEnd;           "refSeq alignment end position col43"
    string mgc;	        "Name of closest mgc to gene col44"
    int mStart;	        "mgc alignment start position col45"
    int mEnd;           "mgc alignment end position col46"
    string kgName;	"Name of closest knownGene to gene col47"
    int kStart;	        "kg alignment start position col48"
    int kEnd;           "kg alignment end position col49"
    string overName;	"name of overlapping mrna col50"
    int overStart;	"overlapping mrna start position col51"
    int overExonCover;  "count of overlapping mrna exons col52"
    char[2] overStrand;  "strand of overlapping mrna col53"
    int overlapDog;     "percent of retro that breaks net relative to dog col54"
    float posConf;      "pvalue for positive col55"
    uint polyAlen;      "length of polyA col56"
    float kaku;         "ratio of substitutions between coding and utr wrt parent gene"
    )
