table tigrCmrGene
"For TIGR CMR genes tracks"
    (
    short  bin;            "Bin number for browser speedup"
    string chrom;          "Reference sequence chromosome or scaffold"
    uint chromStart;       "Start position in chromosome"
    uint chromEnd;         "End position in chromosome"
    string name;           "TIGR locus"
    uint score;            "Score from 900-1000.  1000 is best"
    char[1] strand;        "Value should be + or -"
    lstring tigrCommon;    "TIGR Common Name"
    string tigrGene;       "TIGR Gene Symbol"
    string tigrECN;        "TIGR Enzyme Commission Number"
    string primLocus;      "Primary Locus Name"
    uint tigrLength;       "TIGR sequence length"
    uint tigrPepLength;    "TIGR Protein length"
    lstring tigrMainRole;  "TIGR Main Role"
    lstring tigrSubRole;   "TIGR Sub Role"
    string swissProt;      "SwissProt TrEMBL Accession"
    string genbank;        "Genbank ID"
    float tigrMw;          "Molecular Weight"
    float tigrPi;          "Isoelectric point (I think)"
    float tigrGc;          "GC content"
    string goTerm;         "GO term (gene ontology)"
    )
