/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.xmind.ui.dialogs.HyperlinkPage;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.protocols.FilePathParser;

public class FileHyperlinkPage
extends HyperlinkPage
implements Listener {
    private String basePath = null;
    private String path;
    private boolean relative;
    private File file;
    private Composite composite;
    private Text pathInput;
    private Button relativeButton;
    private Button absoluteButton;
    private Text absolutePathPreview;
    private Button fileChooser;
    private Button folderChooser;
    private boolean ignoreModify = false;
    private boolean warningFileNotExists = false;

    @Override
    public void init(IEditorPart editor, IStructuredSelection selection) {
        File workbookFile = MME.getFile(editor.getEditorInput());
        if (workbookFile != null) {
            this.basePath = workbookFile.getParent();
        }
        if (this.basePath == null) {
            this.basePath = FilePathParser.ABSTRACT_FILE_BASE;
        }
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(this.composite);
        this.createPathInput(this.composite);
        this.createOptionsArea(this.composite);
        this.createPathChoosers(this.composite);
    }

    private void createLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)label.getLayoutData()).widthHint = 380;
        label.setText(DialogMessages.FileHyperlinkPage_label);
    }

    private void createPathInput(Composite parent) {
        this.pathInput = new Text(parent, 2052);
        this.pathInput.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pathInput.addListener(24, (Listener)this);
    }

    private void createOptionsArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, true);
        group.setLayout((Layout)layout);
        group.setText(DialogMessages.FileHyperlinkPage_HrefGroup_Text);
        this.absoluteButton = new Button((Composite)group, 16);
        this.absoluteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.absoluteButton.setText(DialogMessages.FileHyperlinkPage_AbsoluteButton_Text);
        this.absoluteButton.setSelection(true);
        this.absoluteButton.addListener(13, (Listener)this);
        this.relativeButton = new Button((Composite)group, 16);
        this.relativeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.relativeButton.setText(DialogMessages.FileHyperlinkPage_RelativeButton_Text);
        this.relativeButton.addListener(13, (Listener)this);
        this.absolutePathPreview = new Text((Composite)group, 2060);
        this.absolutePathPreview.setBackground(group.getBackground());
        GridData absolutePathPreviewLayoutData = new GridData(4, 4, true, false);
        absolutePathPreviewLayoutData.horizontalSpan = 2;
        this.absolutePathPreview.setLayoutData((Object)absolutePathPreviewLayoutData);
    }

    private void createPathChoosers(Composite parent) {
        Control c;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createFileChooser(composite);
        this.createFolderChooser(composite);
        int maxWidth = 98;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c instanceof Button) {
                maxWidth = Math.max(maxWidth, c.computeSize((int)-1, (int)-1).x);
            }
            ++n2;
        }
        controlArray = composite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            c = controlArray[n2];
            if (c instanceof Button && c.getLayoutData() instanceof GridData) {
                ((GridData)c.getLayoutData()).widthHint = maxWidth;
            }
            ++n2;
        }
    }

    private void createFileChooser(Composite parent) {
        this.fileChooser = new Button(parent, 8);
        this.fileChooser.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fileChooser.setText(DialogMessages.FileHyperlinkPage_ChooseFile_text);
        this.fileChooser.addListener(13, (Listener)this);
    }

    private void createFolderChooser(Composite parent) {
        this.folderChooser = new Button(parent, 8);
        this.folderChooser.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.folderChooser.setText(DialogMessages.FileHyperlinkPage_ChooseFolder_text);
        this.folderChooser.addListener(13, (Listener)this);
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.setPath(value == null ? null : FilePathParser.toPath(value));
    }

    protected void update() {
        if (!this.ignoreModify && this.pathInput != null && !this.pathInput.isDisposed()) {
            this.ignoreModify = true;
            this.pathInput.setText(this.path == null ? "" : this.path);
            this.ignoreModify = false;
        }
        if (this.absoluteButton != null && !this.absoluteButton.isDisposed()) {
            this.absoluteButton.setSelection(!this.relative);
        }
        if (this.relativeButton != null && !this.relativeButton.isDisposed()) {
            this.relativeButton.setSelection(this.relative);
        }
        if (this.absolutePathPreview != null && !this.absolutePathPreview.isDisposed()) {
            this.absolutePathPreview.setText(this.file == null ? "" : this.file.getAbsolutePath());
        }
        this.warningFileNotExists = this.file != null && !this.file.exists();
        this.updateWarningMessage();
        super.setValue(this.computeURI());
        if (this.getValue() != null && this.composite != null && !this.composite.isDisposed()) {
            this.composite.setFocus();
        }
        this.setCanFinish(this.getValue() != null);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.pathInput) {
            if (event.type == 24 && !this.ignoreModify) {
                this.ignoreModify = true;
                this.setPath(this.pathInput.getText());
                this.ignoreModify = false;
            }
        } else if (event.widget == this.fileChooser) {
            FileDialog dialog = this.createFileDialog();
            String path = dialog.open();
            if (path != null) {
                this.setFile(path);
            }
        } else if (event.widget == this.folderChooser) {
            DirectoryDialog dialog = this.createFolderDialog();
            String path = dialog.open();
            if (path != null) {
                this.setFile(path);
            }
        } else if (event.widget == this.relativeButton) {
            this.setRelative(true);
        } else if (event.widget == this.absoluteButton) {
            this.setRelative(false);
        }
    }

    protected DirectoryDialog createFolderDialog() {
        DirectoryDialog dialog = new DirectoryDialog(this.composite.getShell(), 4100);
        dialog.setText(DialogMessages.FileHyperlinkPage_OpenFileDialog_windowTitle);
        return dialog;
    }

    protected FileDialog createFileDialog() {
        FileDialog dialog = new FileDialog(this.composite.getShell(), 4100);
        dialog.setText(DialogMessages.FileHyperlinkPage_OpenFileDialog_windowTitle);
        return dialog;
    }

    protected void setPath(String path) {
        this.path = path == null || "".equals(path) ? null : path;
        boolean bl = this.relative = path == null ? false : FilePathParser.isPathRelative(path);
        this.file = path == null ? null : (this.relative ? new File(FilePathParser.toAbsolutePath(this.basePath, path)) : new File(path));
        this.update();
    }

    protected void setFile(String fullPath) {
        File file = this.file = fullPath == null || "".equals(fullPath) ? null : new File(fullPath);
        this.path = this.file == null ? null : (this.relative ? FilePathParser.toRelativePath(this.basePath, fullPath) : fullPath);
        this.update();
    }

    protected void setRelative(boolean relative) {
        this.relative = relative;
        this.path = this.file == null ? null : (relative ? FilePathParser.toRelativePath(this.basePath, this.file.getAbsolutePath()) : this.file.getAbsolutePath());
        this.update();
    }

    private void updateWarningMessage() {
        this.setMessage(this.warningFileNotExists ? DialogMessages.FileHyperlinkPage_FileNotExists_message : null, 2);
    }

    private String computeURI() {
        return this.path == null ? null : FilePathParser.toURI(this.path, this.relative);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        if (this.pathInput != null && !this.pathInput.isDisposed()) {
            this.pathInput.setFocus();
        }
    }
}

