/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddSheetCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.NewSheetFromTemplateDialog;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.IWorkbookRef;

public class CreateSheetFromTemplateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.createSheetFromTemplate(HandlerUtil.getActiveEditorChecked((ExecutionEvent)event));
        return null;
    }

    private void createSheetFromTemplate(IEditorPart targetEditor) throws ExecutionException {
        IWorkbook targetWorkbook;
        IWorkbookRef targetWorkbookRef = (IWorkbookRef)targetEditor.getAdapter(IWorkbookRef.class);
        IWorkbook iWorkbook = targetWorkbook = targetWorkbookRef == null ? null : targetWorkbookRef.getWorkbook();
        if (targetWorkbook == null) {
            throw new ExecutionException("No workbook available in active editor");
        }
        NewSheetFromTemplateDialog dialog = new NewSheetFromTemplateDialog(targetEditor.getSite().getShell());
        if (dialog.open() != 0) {
            return;
        }
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("CreateSheetCount");
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowTemplatesCount");
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UseTemplatesCount");
        ITemplate template = dialog.getTemplate();
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase(String.format("Template/UseCount/%s", template.getName().replaceAll(" ", "_")));
        Assert.isTrue((template != null ? 1 : 0) != 0);
        final IWorkbookRef tempWorkbookRef = template.createWorkbookRef();
        if (tempWorkbookRef == null) {
            throw new ExecutionException("Failed to create workbook ref from template: " + template.toString());
        }
        final ArrayList commands = new ArrayList();
        IProgressService context = (IProgressService)targetEditor.getSite().getService(IProgressService.class);
        Assert.isTrue((context != null ? 1 : 0) != 0);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CreateSheetFromTemplateHandler.this.createCommands(monitor, commands, tempWorkbookRef, targetWorkbook);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof ExecutionException) {
                throw (ExecutionException)cause;
            }
            if (cause != null) {
                throw new ExecutionException(cause.getMessage(), cause);
            }
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(commands);
        command.setLabel(MindMapMessages.NewSheetFromTemplateDialog_NewSheetFromTemplteCommand_label);
        ICommandStack commandStack = targetWorkbookRef.getCommandStack();
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    private void createCommands(IProgressMonitor monitor, List<Command> commands, IWorkbookRef tempWorkbookRef, IWorkbook targetWorkbook) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        tempWorkbookRef.open((IProgressMonitor)subMonitor.newChild(50));
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IWorkbook tempWorkbook = tempWorkbookRef.getWorkbook();
            Assert.isTrue((tempWorkbook != null ? 1 : 0) != 0);
            this.addCommands((IProgressMonitor)subMonitor.newChild(40), commands, tempWorkbook, targetWorkbook);
        }
        finally {
            tempWorkbookRef.close((IProgressMonitor)subMonitor.newChild(10));
        }
    }

    private void addCommands(IProgressMonitor monitor, List<Command> commands, IWorkbook tempWorkbook, IWorkbook targetWorkbook) {
        int sheetCount = targetWorkbook.getSheets().size();
        for (ISheet tempSheet : tempWorkbook.getSheets()) {
            ISheet sheet = (ISheet)targetWorkbook.clone(Arrays.asList(tempSheet)).get((Object)tempSheet);
            if (sheet == null) continue;
            sheet.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Sheet, (Object)(++sheetCount)));
            commands.add((Command)new AddSheetCommand(sheet, targetWorkbook));
        }
    }
}

