/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.lang.reflect.Field;
import net.xmind.core.AccountManager;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.ColorUtils;

public class SubscriptionInfoDialog
extends TitleAreaDialog {
    public static final int REDEEM_ID = 1025;
    private static int RENEW_ID = 1026;
    private static int PURCHASE_ON_NOT_SUBSCRIBED = 1027;
    private int validityStatus = 0;
    private String user;
    private long expireDate;
    private Image titleImage;
    private LocalResourceManager resources;

    public SubscriptionInfoDialog(Shell parentShell, int validityStatus, String user, long expireDate) {
        super(parentShell);
        this.validityStatus = validityStatus;
        this.user = user;
        this.expireDate = expireDate;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SubscriptionInfoDialog_DialogTitle_Text);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SubscriptionInfoDialog_DialogTitle_Text);
        if (this.titleImage == null) {
            this.titleImage = XMindNet.createBannerLogo();
        }
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        this.setMessage(this.getInfo());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.createInfoArea(composite);
        return composite;
    }

    private void createInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        if (this.validityStatus == 4096) {
            Composite notSubscriptionComposite = new Composite(composite, 0);
            notSubscriptionComposite.setLayout((Layout)new GridLayout());
            notSubscriptionComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            Label imageLabel = new Label(notSubscriptionComposite, 0x1000000);
            imageLabel.setLayoutData((Object)new GridData(1808));
            LocalResourceManager rm = new LocalResourceManager(JFaceResources.getResources(), (Control)imageLabel);
            ImageDescriptor imageDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.xmind.verify", (String)"icons/not-subscription.png");
            if (imageDes != null) {
                imageLabel.setImage(rm.createImage(imageDes));
            }
            this.createInfoLabel(notSubscriptionComposite, Messages.SubscriptionInfoDialog_NotSubscribed_Label, 0x1000008);
        } else {
            this.createInfoLabel(composite, Messages.SubscriptionInfoDialog_XMindID_Label, 0x1000008);
            this.createInfoLabel(composite, this.user, 1);
            String expireDate = this.getExpireDate();
            if (expireDate != null) {
                this.createInfoLabel(composite, Messages.SubscriptionInfoDialog_ExpiryDate_Label, 0x1000008);
                this.createInfoLabel(composite, expireDate, 1);
            }
            this.createInfoLabel(composite, Messages.SubscriptionInfoDialog_StatusLabel, 0x1000008);
            this.createInfoLabel(composite, this.getStatusMessage(), 1);
        }
    }

    private Control createInfoLabel(Composite parent, String text, int horizontalAlignment) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(horizontalAlignment, 1, false, false));
        return label;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = -1;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        Composite leftBar = new Composite(composite, 0);
        GridLayout leftLayout = new GridLayout(1, false);
        leftLayout.numColumns = 1;
        leftLayout.makeColumnsEqualWidth = true;
        leftLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        leftLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        leftLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        leftLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        leftBar.setLayout((Layout)leftLayout);
        GridData leftLayoutData = new GridData(1, 0x1000000, true, false);
        leftLayoutData.widthHint = -1;
        leftLayoutData.heightHint = -1;
        leftBar.setLayoutData((Object)leftLayoutData);
        leftBar.setFont(parent.getFont());
        this.createButtonsForLeftButtonBar(leftBar);
        Composite buttonBar = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 0;
        layout2.makeColumnsEqualWidth = false;
        layout2.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout2.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout2.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout2.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonBar.setLayout((Layout)layout2);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        buttonBar.setFont(parent.getFont());
        this.createButtonsForButtonBar(buttonBar);
        return composite;
    }

    private void createButtonsForLeftButtonBar(Composite parent) {
        if (this.validityStatus == 4096) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 3;
            composite.setLayout((Layout)gridLayout);
            Label label = new Label(composite, 0);
            label.setText(Messages.SubscriptionInfoDialog_HaveSubscriptionCode_Text);
            Hyperlink link = new Hyperlink(composite, 0);
            try {
                Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
                fPaintFocus.setAccessible(true);
                fPaintFocus.set(link, false);
            }
            catch (Throwable throwable) {}
            link.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            link.setUnderlined(true);
            link.setText(Messages.SubscriptionInfoDialog_GoToRedeemLink_Text);
            link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
            link.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor()));
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
                    XMindNet.gotoURL((String)LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)true, (String)"/account/subscription/"), (Object[])new Object[0]);
                }
            });
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 3;
            composite.setLayout((Layout)gridLayout);
            Hyperlink link = new Hyperlink(composite, 0);
            try {
                Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
                fPaintFocus.setAccessible(true);
                fPaintFocus.set(link, false);
            }
            catch (Throwable throwable) {}
            link.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            link.setText(Messages.SubscriptionInfoDialog_SubscriptionHistoryLink_Text);
            link.setUnderlined(true);
            link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
            link.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor()));
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
                    XMindNet.gotoURL((String)LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)true, (String)"/account/subscription/"), (Object[])new Object[0]);
                }
            });
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.validityStatus == 4096) {
            this.createButton(parent, PURCHASE_ON_NOT_SUBSCRIBED, Messages.SubscriptionInfoDialog_PurchaseButton_Label, true);
        } else {
            this.createButton(parent, RENEW_ID, Messages.SubscriptionInfoDialog_RenewButton_Label, true);
        }
        Button okButton = this.createButton(parent, 0, Messages.SubscriptionInfoDialog_OKButton_Label, true);
        okButton.setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == RENEW_ID || buttonId == PURCHASE_ON_NOT_SUBSCRIBED) {
            boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
            XMindNet.gotoURL((String)LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)false, (String)"/xmind/buy/subscription/"), (Object[])new Object[0]);
            return;
        }
        super.buttonPressed(buttonId);
    }

    private String getExpireDate() {
        if (this.expireDate == 0L) {
            return null;
        }
        return String.format("%tF", this.expireDate);
    }

    private String getStatusMessage() {
        if (this.validityStatus == 1) {
            return Messages.SubscriptionInfoDialog_AvailableText;
        }
        if (this.validityStatus == 2048) {
            return Messages.SubscriptionInfoDialog_ExpiredText;
        }
        return "";
    }

    private String getInfo() {
        if (this.validityStatus == 1) {
            return Messages.SubscriptionInfoDialog_MessageArea_ActivedLabel;
        }
        return Messages.SubscriptionInfoDialog_MessageAreaRedeemLabel;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

