/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.i18n;

import com.idiominc.ws.opentopic.fo.i18n.Configuration;
import com.idiominc.ws.opentopic.fo.i18n.MultilanguagePreprocessor;
import java.io.File;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import org.dita.dost.ant.XMLCatalogAdapter;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.ChainedURIResolver;
import org.dita.dost.util.Job;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xmlresolver.Resolver;

public class PreprocessorTask
extends Task {
    private File config = null;
    private URI input = null;
    private URI output = null;
    private URI style = null;
    private XMLCatalog xmlcatalog;

    public void execute() throws BuildException {
        Job job = (Job)this.getProject().getReference("job");
        XMLUtils xmlUtils = (XMLUtils)this.getProject().getReference("xmlutils");
        this.checkParameters();
        this.log("Processing " + this.input + " to " + this.output, 2);
        try {
            DocumentBuilder documentBuilder = XMLUtils.getDocumentBuilder();
            documentBuilder.setEntityResolver((EntityResolver)this.xmlcatalog);
            Document doc = job.getStore().getDocument(this.input);
            Document conf = documentBuilder.parse(this.config);
            MultilanguagePreprocessor preprocessor = new MultilanguagePreprocessor(new Configuration(conf));
            Document document = preprocessor.process(doc);
            if (this.style != null) {
                this.log("Loading stylesheet " + this.style, 2);
                XsltCompiler xsltCompiler = xmlUtils.getProcessor().newXsltCompiler();
                Resolver catalogResolver = this.xmlcatalog != null ? new XMLCatalogAdapter(this.xmlcatalog) : CatalogUtils.getCatalogResolver();
                ChainedURIResolver resolver = new ChainedURIResolver((URIResolver)job.getStore(), (URIResolver)catalogResolver);
                xsltCompiler.setURIResolver((URIResolver)resolver);
                XsltExecutable compile = xsltCompiler.compile(job.getStore().getSource(this.style));
                XsltTransformer t = compile.load();
                t.setURIResolver((URIResolver)resolver);
                t.setSource((Source)new DOMSource(document));
                t.setDestination(job.getStore().getDestination(this.output));
                t.transform();
            } else {
                job.getStore().writeDocument(document, this.output);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void checkParameters() throws BuildException {
        if (null == this.config || null == this.input || null == this.output) {
            throw new BuildException("config, input, output attributes is required");
        }
    }

    public void setConfig(File theConfig) {
        this.config = theConfig;
    }

    public void setInput(File theInput) {
        this.input = theInput.toURI();
    }

    public void setOutput(File theOutput) {
        this.output = theOutput.toURI();
    }

    @Deprecated
    public void setCatalogs(String catalogs) {
        this.log("catalogs attribute has been deprecated, use xmlcatalog nested element", 1);
    }

    public void setStyle(File style) {
        this.style = style.toURI();
    }

    public void addConfiguredXmlcatalog(XMLCatalog xmlcatalog) {
        this.xmlcatalog = xmlcatalog;
    }
}

