/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.pdf2;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class VariableFileTask
extends Task {
    public static final String COMMON_VARIABLE_FILENAME = "commonvariables.xml";
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private File file;

    public void execute() throws BuildException {
        ArrayList<File> files = new ArrayList<File>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String string : ds.getIncludedFiles()) {
                files.add(new File(ds.getBasedir(), string));
            }
        }
        if (files.isEmpty()) {
            this.log("No variable files found", 4);
            return;
        }
        File strings = this.getBaseVariableFile().getAbsoluteFile();
        OutputStream out = null;
        try {
            Document d = XMLUtils.getDocumentBuilder().parse(strings);
            Element root = d.getDocumentElement();
            NodeList nl = root.getElementsByTagName("lang");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element element = (Element)nl.item(i);
                Attr filename = element.getAttributeNode("filename");
                URI f = URLUtils.toURI((String)filename.getValue());
                if (f.isAbsolute()) continue;
                filename.setValue(strings.toURI().resolve(f).toString());
            }
            for (File file : files) {
                Element lang = d.createElement("lang");
                String n = file.getName();
                int i = n.indexOf(46);
                if (n.equals(COMMON_VARIABLE_FILENAME)) {
                    lang.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "");
                } else {
                    lang.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", n.substring(0, i).replace('_', '-'));
                }
                lang.setAttribute("filename", file.toURI().toString());
                root.appendChild(lang);
            }
            new XMLUtils().writeDocument(d, this.file);
        }
        catch (IOException | SAXException e) {
            throw new BuildException("Failed to write output file: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getProject().log("Failed to close output writer", 0);
                }
            }
        }
    }

    private File getBaseVariableFile() {
        String f = this.getProject().getProperty("dita.plugin.org.dita.base.dir");
        if (f != null) {
            return new File(f, "xsl" + File.separator + "common" + File.separator + "strings.xml");
        }
        return null;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setFile(File file) {
        this.file = file;
    }
}

