/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.CleanerFilter;
import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.MarkdownParser;
import com.elovirta.dita.markdown.ParseException;
import com.elovirta.dita.markdown.SpecializeFilter;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarkdownParserImpl
implements MarkdownParser {
    private final DataSet options;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;

    public MarkdownParserImpl(DataSet options) {
        this.options = options;
    }

    @Override
    public void convert(BasedSequence sequence, URI input) throws SAXException {
        Parser parser = Parser.builder((DataHolder)this.options).build();
        Document root = parser.parse(sequence);
        try {
            Document cleaned = this.preprocess(root, input);
            this.validate(cleaned);
            this.render(cleaned);
        }
        catch (ParseException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new SAXException(e);
        }
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void render(Document root) {
        SpecializeFilter specialize;
        ContentHandler res = this.contentHandler;
        CleanerFilter cleanerFilter = new CleanerFilter();
        cleanerFilter.setContentHandler(res);
        res = cleanerFilter;
        if (((Boolean)DitaRenderer.SPECIALIZATION.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter();
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_CONCEPT.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.CONCEPT);
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_TASK.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.TASK);
            specialize.setContentHandler(res);
            res = specialize;
        } else if (((Boolean)DitaRenderer.SPECIALIZATION_REFERENCE.get((DataHolder)this.options)).booleanValue()) {
            specialize = new SpecializeFilter(SpecializeFilter.Type.REFERENCE);
            specialize.setContentHandler(res);
            res = specialize;
        }
        DitaRenderer s = new DitaRenderer(this.options);
        s.render((Node)root, res);
    }

    protected void validate(Document root) {
        boolean mditaCoreProfile = (Boolean)DitaRenderer.MDITA_CORE_PROFILE.getFrom((DataHolder)this.options);
        boolean mditaExtendedProfile = (Boolean)DitaRenderer.MDITA_EXTENDED_PROFILE.getFrom((DataHolder)this.options) != false || (Boolean)DitaRenderer.LW_DITA.getFrom((DataHolder)this.options) != false;
        int level = 0;
        for (Node node = root.getFirstChild(); node != null; node = node.getNext()) {
            if (!(node instanceof Heading)) continue;
            Heading heading = (Heading)node;
            if ((mditaCoreProfile || mditaExtendedProfile) && heading.getLevel() > 2) {
                throw new ParseException(String.format("LwDITA does not support level %d heading: %s", heading.getLevel(), heading.getText()));
            }
            if (heading.getLevel() > level + 1) {
                throw new ParseException(String.format("Heading level raised from %d to %d without intermediate heading level", level, heading.getLevel()));
            }
            level = heading.getLevel();
        }
    }

    protected Document preprocess(Document root, URI input) throws SAXException {
        if (((Boolean)DitaRenderer.WIKI.get((DataHolder)this.options)).booleanValue() && MarkdownParserImpl.isWiki(root)) {
            this.generateRootHeading(root, input);
        }
        if (((Boolean)DitaRenderer.FIX_ROOT_HEADING.get((DataHolder)this.options)).booleanValue() && MarkdownParserImpl.isWiki(root)) {
            if (this.errorHandler != null) {
                this.errorHandler.warning(new SAXParseException("Document content doesn't start with heading", null, input.toString(), 1, 1));
            }
            this.generateRootHeading(root, input);
        }
        return root;
    }

    private void generateRootHeading(Document root, URI input) {
        YamlFrontMatterBlock yaml = root.getFirstChild() instanceof YamlFrontMatterBlock ? (YamlFrontMatterBlock)root.getFirstChild() : null;
        String title = this.getTextFromFile(input);
        Heading heading = new Heading();
        if (yaml != null) {
            List titles;
            AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
            v.visit((Node)root);
            Map metadata = v.getData();
            List ids = (List)metadata.get("id");
            if (ids != null && !ids.isEmpty()) {
                heading.setAnchorRefId((String)ids.get(0));
            }
            if ((titles = (List)metadata.get("title")) != null && !titles.isEmpty() && ((title = (String)titles.get(0)).charAt(0) == '\'' && title.charAt(title.length() - 1) == '\'' || title.charAt(0) == '\"' && title.charAt(title.length() - 1) == '\"')) {
                title = title.substring(1, title.length() - 1);
            }
        }
        heading.setLevel(1);
        AnchorLink anchorLink = new AnchorLink();
        anchorLink.appendChild((Node)new Text(title));
        heading.appendChild((Node)anchorLink);
        root.prependChild((Node)heading);
    }

    private static boolean isWiki(Document root) {
        Node firstChild = root.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (firstChild instanceof YamlFrontMatterBlock) {
            firstChild = firstChild.getNext();
        }
        return !(firstChild instanceof Heading) || ((Heading)firstChild).getLevel() != 1;
    }

    private String getTextFromFile(URI file) {
        String path = file.getPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        String title = name.lastIndexOf(".") != -1 ? name.substring(0, name.lastIndexOf(".")) : name;
        return title.replace('_', ' ').replace('-', ' ');
    }
}

