/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.renderer.DitaIdGenerator;
import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashMap;

public class HeaderIdGenerator
implements DitaIdGenerator {
    @Override
    public void generateIds(Document document) {
        final HashMap headerBaseIds = new HashMap();
        final boolean resolveDupes = (Boolean)DitaRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.getFrom((DataHolder)document);
        final String toDashChars = (String)DitaRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom((DataHolder)document);
        final boolean noDupedDashes = (Boolean)DitaRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.getFrom((DataHolder)document);
        new AnchorRefTargetBlockVisitor(){

            protected void visit(AnchorRefTarget node) {
                String text = node.getAnchorRefText();
                if (!text.isEmpty()) {
                    Object baseRefId = HeaderIdGenerator.generateId(text, toDashChars, noDupedDashes);
                    if (resolveDupes) {
                        if (headerBaseIds.containsKey(baseRefId)) {
                            int index = (Integer)headerBaseIds.get(baseRefId);
                            headerBaseIds.put(baseRefId, ++index);
                            baseRefId = (String)baseRefId + "-" + index;
                        } else {
                            headerBaseIds.put(baseRefId, 0);
                        }
                    }
                    node.setAnchorRefId((String)baseRefId);
                }
            }
        }.visit((Node)document);
    }

    @Override
    public String getId(Node node) {
        return node instanceof AnchorRefTarget ? ((AnchorRefTarget)node).getAnchorRefId() : null;
    }

    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes) {
        int iMax = headerText.length();
        StringBuilder baseRefId = new StringBuilder(iMax);
        if (toDashChars == null) {
            toDashChars = " -_";
        }
        for (int i = 0; i < iMax; ++i) {
            char c = headerText.charAt(i);
            if (HeaderIdGenerator.isAlphabetic(c)) {
                baseRefId.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isDigit(c)) {
                baseRefId.append(c);
                continue;
            }
            if (toDashChars.indexOf(c) == -1 || noDupedDashes && (c != '-' || baseRefId.length() != 0) && (baseRefId.length() == 0 || baseRefId.charAt(baseRefId.length() - 1) == '-')) continue;
            baseRefId.append('-');
        }
        return baseRefId.toString();
    }

    public static boolean isAlphabetic(char c) {
        return (1086 >> Character.getType((int)c) & 1) != 0;
    }
}

