/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MapMetaReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.ChainedURIResolver;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.DitaMapMetaWriter;
import org.dita.dost.writer.DitaMetaWriter;
import org.w3c.dom.Element;

final class MoveMetaModule
extends AbstractPipelineModuleImpl {
    MoveMetaModule() {
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Collection<Job.FileInfo> fis = this.job.getFileInfo(fi -> fi.isInput);
        if (!fis.isEmpty()) {
            Map<URI, Map<String, Element>> mapSet = this.getMapMetadata(fis);
            this.pushMetadata(mapSet);
            this.pullTopicMetadata(input, fis);
        }
        return null;
    }

    private void pullTopicMetadata(AbstractPipelineInput input, Collection<Job.FileInfo> fis) throws DITAOTException {
        XsltExecutable xsltExecutable;
        File styleFile = new File(input.getAttribute("style"));
        this.logger.info("Loading stylesheet " + styleFile);
        try {
            XsltCompiler xsltCompiler = this.xmlUtils.getXsltCompiler();
            xsltExecutable = xsltCompiler.compile((Source)new StreamSource(styleFile));
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Failed to compile stylesheet '" + styleFile.toURI() + "': " + e.getMessage(), e);
        }
        for (Job.FileInfo f : fis) {
            File inputFile = new File(this.job.tempDirURI.resolve(f.uri));
            File tmp = new File(inputFile.getAbsolutePath() + ".tmp" + Long.toString(System.currentTimeMillis()));
            this.logger.info("Processing " + inputFile.toURI());
            this.logger.debug("Processing " + inputFile.toURI() + " to " + tmp.toURI());
            Destination result = null;
            try {
                XsltTransformer transformer = xsltExecutable.load();
                transformer.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
                transformer.setURIResolver((URIResolver)new ChainedURIResolver(this.job.getStore(), (URIResolver)CatalogUtils.getCatalogResolver()));
                transformer.setMessageListener(XMLUtils.toMessageListener(this.logger, this.processingMode));
                for (Map.Entry<String, String> e : input.getAttributes().entrySet()) {
                    this.logger.debug("Set parameter " + e.getKey() + " to '" + e.getValue() + "'");
                    transformer.setParameter(new QName(e.getKey()), XdmItem.makeValue((Object)e.getValue()));
                }
                Source source = this.job.getStore().getSource(inputFile.toURI());
                transformer.setSource(source);
                result = this.job.getStore().getDestination(tmp.toURI());
                result.setDestinationBaseURI(inputFile.toURI());
                transformer.setDestination(result);
                transformer.transform();
            }
            catch (UncheckedXPathException e) {
                throw new DITAOTException("Failed to transform document", e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DITAOTException("Failed to transform document: " + e.getMessage(), e);
            }
            finally {
                try {
                    result.close();
                }
                catch (SaxonApiException e) {
                    throw new DITAOTException("Failed to transform document", e);
                }
            }
            try {
                this.logger.debug("Moving " + tmp.toURI() + " to " + inputFile.toURI());
                this.job.getStore().move(tmp.toURI(), inputFile.toURI());
            }
            catch (IOException e) {
                throw new DITAOTException("Failed to replace document: " + e.getMessage(), e);
            }
        }
    }

    private void pushMetadata(Map<URI, Map<String, Element>> mapSet) {
        if (!mapSet.isEmpty()) {
            DitaMapMetaWriter mapInserter = new DitaMapMetaWriter();
            mapInserter.setLogger(this.logger);
            mapInserter.setJob(this.job);
            for (Map.Entry<URI, Map<String, Element>> entry : mapSet.entrySet()) {
                URI key = URLUtils.stripFragment(entry.getKey());
                Job.FileInfo fi = this.job.getFileInfo(key);
                if (fi == null) {
                    this.logger.error("File " + this.job.tempDirURI.resolve(key) + " was not found.");
                    continue;
                }
                URI targetFileName = this.job.tempDirURI.resolve(fi.uri);
                assert (targetFileName.isAbsolute());
                if (fi.format == null || !"ditamap".equals(fi.format)) continue;
                mapInserter.setMetaTable(entry.getValue());
                if (this.job.getStore().exists(targetFileName)) {
                    try {
                        mapInserter.read(URLUtils.toFile(targetFileName));
                    }
                    catch (DITAOTException e) {
                        this.logger.error("Failed to read " + targetFileName + ": " + e.getMessage(), e);
                    }
                    continue;
                }
                this.logger.error("File " + targetFileName + " does not exist");
            }
            DitaMetaWriter topicInserter = new DitaMetaWriter();
            topicInserter.setLogger(this.logger);
            topicInserter.setJob(this.job);
            for (Map.Entry<URI, Map<String, Element>> entry : mapSet.entrySet()) {
                URI key = URLUtils.stripFragment(entry.getKey());
                Job.FileInfo fi = this.job.getFileInfo(key);
                if (fi == null) {
                    this.logger.error("File " + this.job.tempDirURI.resolve(key) + " was not found.");
                    continue;
                }
                URI targetFileName = this.job.tempDirURI.resolve(fi.uri);
                assert (targetFileName.isAbsolute());
                if (fi.format != null && !fi.format.equals("dita")) continue;
                String topicid = entry.getKey().getFragment();
                topicInserter.setTopicId(topicid);
                topicInserter.setMetaTable(entry.getValue());
                try {
                    topicInserter.read(URLUtils.toFile(targetFileName));
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to read " + targetFileName + ": " + e.getMessage(), e);
                }
            }
        }
    }

    private Map<URI, Map<String, Element>> getMapMetadata(Collection<Job.FileInfo> fis) {
        MapMetaReader metaReader = new MapMetaReader();
        metaReader.setLogger(this.logger);
        metaReader.setJob(this.job);
        for (Job.FileInfo f : fis) {
            File mapFile = this.job.tempDir.toPath().resolve(f.file.toPath()).toFile();
            try {
                metaReader.read(mapFile);
            }
            catch (DITAOTException e) {
                this.logger.error("Failed to read " + mapFile + ": " + e.getMessage(), e);
            }
        }
        return metaReader.getMapping();
    }
}

