/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.IAction;
import org.dita.dost.platform.Integrator;
import org.dita.dost.platform.Value;
import org.dita.dost.util.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class InsertDependsAction
implements IAction {
    private List<Value> value;
    private Map<String, Features> featureTable = null;

    InsertDependsAction() {
    }

    @Override
    public void getResult(ContentHandler buf) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getResult() {
        ArrayList<String> result = new ArrayList<String>();
        for (Value t : this.value) {
            String token = t.value().trim();
            if (token.startsWith("{") && token.endsWith("}")) {
                String extension = token.substring(1, token.length() - 1);
                String extensionInputs = Integrator.getValue(this.featureTable, extension);
                if (extensionInputs == null) continue;
                result.add(extensionInputs);
                continue;
            }
            result.add(token);
        }
        if (!result.isEmpty()) {
            return StringUtils.join(result, ",");
        }
        return "";
    }

    @Override
    public void setInput(List<Value> input) {
        this.value = input;
    }

    @Override
    public void addParam(String name, String value) {
    }

    @Override
    public void setFeatures(Map<String, Features> h) {
        this.featureTable = h;
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
    }
}

