/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.BuildException;
import org.dita.dost.invoker.Main;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Alias;
import org.dita.dost.platform.Integrator;
import org.dita.dost.platform.Plugins;
import org.dita.dost.platform.Registry;
import org.dita.dost.platform.SemVer;
import org.dita.dost.platform.SemVerMatch;
import org.dita.dost.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PluginInstall {
    private List<String> registries;
    private File tempDir;
    private final ObjectMapper mapper = new ObjectMapper();
    private List<String> installedPlugins;
    private Integrator integrator;
    private DITAOTLogger logger;
    private File ditaDir;
    private Path pluginFile;
    private URI pluginUri;
    private String pluginName;
    private SemVerMatch pluginVersion;
    private boolean force;

    private void init() {
        this.registries = Arrays.stream(Configuration.configuration.get("registry").trim().split("\\s+")).map(registry -> registry.endsWith("/") ? registry : registry + "/").collect(Collectors.toList());
        try {
            this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new BuildException("Failed to create temporary directory: " + e.getMessage(), (Throwable)e);
        }
        this.installedPlugins = Plugins.getInstalledPlugins().stream().map(Map.Entry::getKey).toList();
        this.integrator = new Integrator(this.ditaDir);
        this.integrator.setLogger(this.logger);
    }

    public void execute() throws Exception {
        this.init();
        if (this.pluginFile != null || this.pluginUri != null || this.pluginName != null) {
            this.installPlugin();
        }
        try {
            this.integrator.execute();
        }
        catch (Exception e) {
            throw new BuildException("Integration failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void installPlugin() throws Exception {
        try {
            String name;
            HashMap<String, Object> installs = new HashMap<String, Object>();
            if (this.pluginFile != null && Files.exists(this.pluginFile, new LinkOption[0])) {
                Path tempPluginDir = this.unzip(this.pluginFile.toFile());
                String name2 = this.getPluginName(tempPluginDir);
                installs.put(name2, tempPluginDir);
            } else if (this.pluginUri != null) {
                File tempFile = this.get(this.pluginUri, null);
                Path tempPluginDir = this.unzip(tempFile);
                name = this.getPluginName(tempPluginDir);
                installs.put(name, tempPluginDir);
            } else {
                Set<Registry> plugins = this.readRegistry(this.pluginName, this.pluginVersion);
                for (Registry plugin : plugins) {
                    File tempFile = this.get(plugin.url.toURI(), plugin.cksum);
                    Path tempPluginDir = this.unzip(tempFile);
                    String name3 = plugin.name;
                    installs.put(name3, tempPluginDir);
                }
            }
            for (Map.Entry install : installs.entrySet()) {
                name = (String)install.getKey();
                Path tempPluginDir = (Path)install.getValue();
                File pluginDir = this.getPluginDir(name);
                if (pluginDir.exists()) {
                    if (this.force) {
                        this.logger.info("Force install to {0}", pluginDir);
                        this.integrator.addRemoved(name);
                        FileUtils.deleteDirectory((File)pluginDir);
                    } else {
                        this.logger.warn(Main.locale.getString("install.error.exists"), name);
                        throw new BuildException();
                    }
                }
                FileUtils.copyDirectory((File)tempPluginDir.toFile(), (File)pluginDir);
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        if (this.tempDir != null) {
            try {
                this.logger.trace("Delete {}", this.tempDir);
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private String getFileHash(File file) {
        String string;
        DigestInputStream digestInputStream = new DigestInputStream(new BufferedInputStream(new FileInputStream(file)), MessageDigest.getInstance("SHA-256"));
        try {
            IOUtils.copy((InputStream)digestInputStream, (OutputStream)new NullOutputStream());
            MessageDigest digest = digestInputStream.getMessageDigest();
            byte[] sha256 = digest.digest();
            string = this.printHexBinary(sha256);
        }
        catch (Throwable throwable) {
            try {
                try {
                    digestInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new BuildException("Failed to calculate file checksum: " + e.getMessage(), (Throwable)e);
            }
        }
        digestInputStream.close();
        return string;
    }

    private String printHexBinary(byte[] md5) {
        StringBuilder sb = new StringBuilder();
        for (byte b : md5) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString().toLowerCase();
    }

    private String getPluginName(Path pluginDir) {
        Path config = pluginDir.resolve("plugin.xml");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(config.toFile());
            return doc.getDocumentElement().getAttribute("id");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new BuildException("Failed to read plugin name: " + e.getMessage(), (Throwable)e);
        }
    }

    private File getPluginDir(String id) {
        return Paths.get(this.ditaDir.getAbsolutePath(), "plugins", id).toFile();
    }

    private Set<Registry> readRegistry(String name, SemVerMatch version) {
        this.logger.trace("Reading registries for {0} {1}", name, Objects.requireNonNullElse(version, ""));
        Registry res = null;
        for (String registry : this.registries) {
            URI registryUrl = URI.create(registry + name + ".json");
            this.logger.debug("Read registry {0}", registry);
            try (BufferedInputStream in = new BufferedInputStream(registryUrl.toURL().openStream());){
                this.logger.trace("Parse registry");
                JsonFactory factory = this.mapper.getFactory();
                JsonParser parser = factory.createParser((InputStream)in);
                JsonNode obj = (JsonNode)this.mapper.readTree(parser);
                Collection<Registry> regs = obj.isArray() ? Arrays.asList((Registry[])this.mapper.treeToValue((TreeNode)obj, Registry[].class)) : this.resolveAlias((Alias)this.mapper.treeToValue((TreeNode)obj, Alias.class));
                Optional<Registry> reg = this.findPlugin(regs, version);
                if (!reg.isPresent()) continue;
                Registry plugin = reg.get();
                this.logger.trace("Plugin found at {0}@{1}", registryUrl, plugin.vers);
                res = plugin;
                break;
            }
            catch (MalformedURLException e) {
                this.logger.error("Invalid registry URL {0}: {1}", new Object[]{registryUrl, e.getMessage(), e});
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                this.logger.error("Failed to read registry configuration {0}: {1}", new Object[]{registryUrl, e.getMessage(), e});
            }
        }
        if (res == null) {
            throw new BuildException(Main.locale.getString("install.error.not_found_from_registry").formatted(this.pluginFile));
        }
        HashSet<Registry> results = new HashSet<Registry>();
        results.add(res);
        res.deps.stream().filter(dep -> !this.installedPlugins.contains(dep.name)).flatMap(dep -> this.readRegistry(dep.name, dep.req).stream()).forEach(results::add);
        return results;
    }

    private Collection<Registry> resolveAlias(Alias registry) {
        return this.readRegistry(registry.alias(), null);
    }

    private File get(URI uri, String expectedChecksum) throws Exception {
        String checksum;
        File tempPluginFile = new File(this.tempDir, "plugin.zip");
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).build();
        try {
            this.logger.debug("Download {}", request.uri());
            client.send(request, HttpResponse.BodyHandlers.ofFile(tempPluginFile.toPath()));
        }
        catch (IOException | InterruptedException e) {
            throw new Exception(Main.locale.getString("install.error.download_failure").formatted(uri), e);
        }
        if (expectedChecksum != null && !(checksum = this.getFileHash(tempPluginFile)).equalsIgnoreCase(expectedChecksum)) {
            throw new BuildException(Main.locale.getString("install.error.checksum_mismatch").formatted(checksum, expectedChecksum));
        }
        return tempPluginFile;
    }

    private Path unzip(File input) throws Exception {
        Path tempPluginDir = new File(this.tempDir, "plugin").toPath();
        this.logger.trace("Expanding {0} to {1}", input, tempPluginDir);
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]));){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = tempPluginDir.resolve(ze.getName()).normalize();
                if (!resolvedPath.startsWith(tempPluginDir)) {
                    throw new Exception("Entry with an illegal path: %s".formatted(ze.getName()));
                }
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                this.logger.trace("Write {0}", resolvedPath);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new Exception("Failed to expand %s to %s".formatted(input, tempPluginDir), e);
        }
        return this.findBaseDir(tempPluginDir);
    }

    private Path findBaseDir(Path tempPluginDir) throws Exception {
        try {
            return Files.find(tempPluginDir, 256, (path, attributes) -> path.getFileName().toString().equals("plugin.xml"), new FileVisitOption[0]).findFirst().orElseThrow(() -> new IOException("plugin.xml not found")).getParent();
        }
        catch (NoSuchFileException e) {
            throw new Exception(Main.locale.getString("install.error.plugin_xml_not_found"));
        }
    }

    private Optional<Registry> findPlugin(Collection<Registry> regs, SemVerMatch version) {
        if (version == null) {
            return regs.stream().filter(this::matchingPlatformVersion).max(Comparator.comparing(o -> o.vers));
        }
        return regs.stream().filter(this::matchingPlatformVersion).filter(reg -> version.contains(reg.vers)).findFirst();
    }

    @VisibleForTesting
    boolean matchingPlatformVersion(Registry reg) {
        Optional<Registry.Dependency> platformDependency = reg.deps.stream().filter(dep -> dep.name.equals("org.dita.base")).findFirst();
        if (platformDependency.isPresent()) {
            SemVer platform = new SemVer(Configuration.configuration.get("otversion"));
            Registry.Dependency dep2 = platformDependency.get();
            return dep2.req.contains(platform);
        }
        return true;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setDitaDir(File ditaDir) {
        this.ditaDir = ditaDir;
    }

    public void setPluginFile(Path pluginFile) {
        this.pluginFile = pluginFile;
    }

    public void setPluginUri(URI pluginUri) {
        this.pluginUri = pluginUri;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setPluginVersion(SemVerMatch pluginVersion) {
        this.pluginVersion = pluginVersion;
    }
}

