/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Plugins {
    public static List<Map.Entry<String, String>> getInstalledPlugins() {
        List plugins = XMLUtils.toList(Plugins.getPluginConfiguration().getElementsByTagName("plugin"));
        return plugins.stream().map(elem -> new AbstractMap.SimpleImmutableEntry<String, String>(Optional.ofNullable(elem.getAttributeNode("id")).map(Attr::getValue).orElse(null), Optional.ofNullable(elem.getAttributeNode("version")).map(Attr::getValue).orElse(null))).filter(entry -> Objects.nonNull(entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    public static Document getPluginConfiguration() {
        Document document;
        block8: {
            InputStream in = Plugins.class.getClassLoader().getResourceAsStream("plugins.xml");
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new RuntimeException("Failed to read plugin configuration: " + e.getMessage(), e);
                }
            }
            in.close();
        }
        return document;
    }
}

