/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ConrefPushReader
extends AbstractXMLReader {
    private final Hashtable<File, Hashtable<MoveKey, DocumentFragment>> pushtable = new Hashtable();
    private final Document pushDocument = XMLUtils.getDocumentBuilder().newDocument();
    private File fileDir = null;
    private File parsefilename = null;
    private XMLStreamWriter pushcontentWriter;
    private DocumentFragment pushcontentDocumentFragment;
    private boolean start = false;
    private int level = 0;
    private URI target = null;
    private String pushType = null;

    public Map<File, Hashtable<MoveKey, DocumentFragment>> getPushMap() {
        return Collections.unmodifiableMap(this.pushtable);
    }

    @Override
    public void read(File filename) {
        assert (filename.isAbsolute());
        this.fileDir = filename.getParentFile().getAbsoluteFile();
        this.parsefilename = new File(filename.getName());
        this.start = false;
        this.pushcontentWriter = this.getXMLStreamWriter();
        this.pushType = null;
        try {
            this.job.getStore().transform(filename.toURI(), this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private XMLStreamWriter getXMLStreamWriter() {
        this.pushcontentDocumentFragment = this.pushDocument.createDocumentFragment();
        try {
            return XMLOutputFactory.newInstance().createXMLStreamWriter(new DOMResult(this.pushcontentDocumentFragment));
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.start) {
            ++this.level;
            this.putElement(name, atts, false);
        }
        String conactValue = atts.getValue("conaction");
        if (!this.start && conactValue != null) {
            switch (conactValue) {
                case "pushbefore": {
                    if (this.pushcontentDocumentFragment.getChildNodes().getLength() != 0) {
                        if (this.pushcontentWriter != null) {
                            try {
                                this.pushcontentWriter.close();
                            }
                            catch (XMLStreamException e) {
                                throw new SAXException(e);
                            }
                        }
                        this.pushcontentWriter = this.getXMLStreamWriter();
                        this.logger.warn(MessageUtils.getMessage("DOTJ044W", new String[0]).setLocation(atts).toString());
                    }
                    this.start = true;
                    this.level = 1;
                    this.putElement(name, atts, true);
                    this.pushType = "pushbefore";
                    break;
                }
                case "pushafter": {
                    this.start = true;
                    this.level = 1;
                    if (this.target == null) {
                        this.logger.error(MessageUtils.getMessage("DOTJ039E", new String[0]).setLocation(atts).toString());
                        break;
                    }
                    this.putElement(name, atts, true);
                    this.pushType = "pushafter";
                    break;
                }
                case "pushreplace": {
                    this.start = true;
                    this.level = 1;
                    this.target = URLUtils.toURI(atts.getValue("conref"));
                    if (this.target == null) {
                        this.logger.error(MessageUtils.getMessage("DOTJ040E", new String[0]).setLocation(atts).toString());
                        break;
                    }
                    this.pushType = "pushreplace";
                    this.putElement(name, atts, true);
                    break;
                }
                case "mark": {
                    this.target = URLUtils.toURI(atts.getValue("conref"));
                    if (this.target == null) {
                        this.logger.error(MessageUtils.getMessage("DOTJ068E", new String[0]).setLocation(atts).toString());
                    }
                    if (this.target == null || this.pushcontentDocumentFragment == null || this.pushcontentDocumentFragment.getChildNodes().getLength() <= 0 || !"pushbefore".equals(this.pushType)) break;
                    if (this.pushcontentWriter != null) {
                        try {
                            this.pushcontentWriter.close();
                        }
                        catch (XMLStreamException e) {
                            throw new SAXException(e);
                        }
                    }
                    this.addtoPushTable(this.target, this.replaceContent(this.pushcontentDocumentFragment), this.pushType);
                    this.pushcontentWriter = this.getXMLStreamWriter();
                    this.target = null;
                    this.pushType = null;
                }
            }
        }
    }

    private DocumentFragment replaceContent(DocumentFragment pushcontent) {
        NodeList children = pushcontent.getChildNodes();
        block3: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element e = (Element)child;
                    this.replaceLinkAttributes(e);
                    NodeList elements = e.getElementsByTagName("*");
                    int j = 0;
                    while (i < elements.getLength()) {
                        this.replaceLinkAttributes((Element)elements.item(j));
                        ++i;
                    }
                    continue block3;
                }
            }
        }
        return pushcontent;
    }

    private void replaceLinkAttributes(Element pushcontent) {
        for (String attName : new String[]{"href", "conref"}) {
            Attr att = pushcontent.getAttributeNode(attName);
            if (att == null) continue;
            att.setNodeValue(this.replaceURL(att.getNodeValue()));
        }
    }

    private void putElement(String elemName, Attributes atts, boolean removeConref) throws SAXException {
        HashSet<String> namespaces = new HashSet<String>();
        try {
            this.pushcontentWriter.writeStartElement(elemName);
            for (int index = 0; index < atts.getLength(); ++index) {
                int offset;
                String prefix;
                String name = atts.getQName(index);
                if (removeConref && ("conref".equals(name) || "conaction".equals(name))) continue;
                String value = atts.getValue(index);
                if ("href".equals(name) || "conref".equals(name)) {
                    value = this.replaceURL(value);
                }
                String string = prefix = (offset = atts.getQName(index).indexOf(":")) != -1 ? atts.getQName(index).substring(0, offset) : "";
                if (!namespaces.contains(prefix)) {
                    namespaces.add(prefix);
                    if (!prefix.isEmpty()) {
                        this.pushcontentWriter.writeNamespace(prefix, atts.getURI(index));
                    }
                }
                this.pushcontentWriter.writeAttribute(prefix, atts.getURI(index), atts.getLocalName(index), value);
            }
            if ("pushreplace".equals(this.pushType) && atts.getValue("id") == null && this.level == 1) {
                String fragment = this.target.getFragment();
                if (fragment == null) {
                    this.logger.error(MessageUtils.getMessage("DOTJ041E", this.target.toString()).setLocation(atts).toString());
                } else {
                    String id = fragment.contains("/") ? fragment.substring(fragment.lastIndexOf("/") + 1) : fragment;
                    this.pushcontentWriter.writeAttribute("id", id);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private String replaceURL(String value) {
        if (value == null) {
            return null;
        }
        if (this.target == null || FileUtils.isAbsolutePath(value) || value.contains("://") || value.startsWith("#")) {
            return value;
        }
        String source = FileUtils.resolve(this.fileDir, this.target).getPath();
        String urltarget = FileUtils.resolveTopic(this.fileDir, value);
        return FileUtils.getRelativeUnixPath(source, urltarget);
    }

    private void addtoPushTable(URI target, DocumentFragment pushcontent, String type) {
        Hashtable<Object, Object> table;
        File key;
        if (target.getFragment() == null) {
            this.logger.error(MessageUtils.getMessage("DOTJ041E", target.toString()).toString());
            return;
        }
        if (target.getPath().isEmpty()) {
            target = URLUtils.toURI(this.parsefilename.getPath() + target);
        }
        if (this.pushtable.containsKey(key = URLUtils.toFile(FileUtils.resolve(this.fileDir, target)))) {
            table = this.pushtable.get(key);
        } else {
            table = new Hashtable();
            this.pushtable.put(key, table);
        }
        MoveKey moveKey = new MoveKey("#" + target.getFragment(), type);
        if (table.containsKey(moveKey)) {
            if ("pushreplace".equals(type)) {
                this.logger.error(MessageUtils.getMessage("DOTJ042E", target.toString()).toString());
            } else {
                table.put(moveKey, this.appendPushContent(pushcontent, (DocumentFragment)table.get(moveKey)));
            }
        } else {
            table.put(moveKey, this.appendPushContent(pushcontent, null));
        }
    }

    private DocumentFragment appendPushContent(DocumentFragment pushcontent, DocumentFragment target) {
        DocumentFragment df = target;
        if (df == null) {
            df = this.pushDocument.createDocumentFragment();
        }
        NodeList children = pushcontent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            df.appendChild(this.pushDocument.importNode(children.item(i), true));
        }
        return df;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.start) {
            try {
                this.pushcontentWriter.writeCharacters(ch, start, length);
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.start) {
            --this.level;
            try {
                this.pushcontentWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }
        if (this.level == 0) {
            this.start = false;
            if (("pushafter".equals(this.pushType) || "pushreplace".equals(this.pushType)) && this.target != null) {
                if (this.pushcontentWriter != null) {
                    try {
                        this.pushcontentWriter.close();
                    }
                    catch (XMLStreamException e) {
                        throw new SAXException(e);
                    }
                }
                this.addtoPushTable(this.target, this.pushcontentDocumentFragment, this.pushType);
                this.pushcontentWriter = this.getXMLStreamWriter();
                this.target = null;
                this.pushType = null;
            }
        }
    }

    public record MoveKey(String idPath, String action) {
        @Override
        public String toString() {
            return this.idPath + "|" + this.action;
        }
    }
}

