/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.Sender;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.RebasedDocument;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.store.AbstractStore;
import org.dita.dost.store.Store;
import org.dita.dost.store.StreamStore;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public class CacheStore
extends AbstractStore
implements Store {
    private final StreamStore fallback;
    private final Map<URI, Entry> cache;

    public CacheStore(File tempDir, XMLUtils xmlUtils) {
        super(tempDir, xmlUtils);
        this.fallback = new StreamStore(tempDir, xmlUtils);
        this.cache = new HashMap<URI, Entry>();
    }

    @Override
    public void delete(URI file) throws IOException {
        URI f = file.normalize();
        if (this.isTempFile(f) && this.cache.containsKey(f)) {
            this.remove(f);
            return;
        }
        this.cacheMiss(f);
        this.fallback.delete(file);
    }

    @Override
    public void copy(URI src, URI dst) throws IOException {
        if (this.cache.containsKey(src)) {
            URI s = this.toAbsolute(src);
            Entry entry = this.get(s);
            URI d = this.toAbsolute(dst);
            this.put(d, entry);
            return;
        }
        this.cacheMiss(src);
        this.fallback.copy(src, dst);
    }

    @Override
    public void move(URI src, URI dst) throws IOException {
        if (this.cache.containsKey(src)) {
            URI s = this.toAbsolute(src);
            URI d = this.toAbsolute(dst);
            Entry remove = this.remove(s);
            Entry wrap = this.rebase(remove, d);
            this.put(d, wrap);
            return;
        }
        this.cacheMiss(src);
        this.fallback.move(src, dst);
    }

    @Override
    public boolean exists(URI path) {
        URI f = URLUtils.stripFragment(this.toAbsolute(path)).normalize();
        if (this.cache.containsKey(f)) {
            return true;
        }
        return this.fallback.exists(f);
    }

    @Override
    public long getLastModified(URI path) {
        URI f = URLUtils.stripFragment(this.toAbsolute(path)).normalize();
        if (this.cache.containsKey(f)) {
            return this.cache.get((Object)f).lastModified;
        }
        return this.fallback.getLastModified(f);
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        URI b = this.toAbsolute(URLUtils.toURI(base));
        URI h = URLUtils.toURI(href);
        assert (b.isAbsolute());
        assert (h.isAbsolute());
        URI f = b.resolve(h).normalize();
        if (this.isTempFile(f) && this.cache.containsKey(f)) {
            Entry entry = this.get(f);
            return this.toSource(entry, f);
        }
        return this.fallback.resolve(href, base);
    }

    @Override
    public Source getSource(URI path) {
        assert (path.isAbsolute());
        URI f = this.getUri(path).normalize();
        if (this.isTempFile(f)) {
            if (this.cache.containsKey(f)) {
                Entry entry = this.get(f);
                return this.toSource(entry, f);
            }
            this.cacheMiss(f);
        }
        return this.fallback.getSource(f);
    }

    @Override
    public Document getImmutableDocument(URI path) throws IOException {
        URI f = this.toAbsolute(path);
        if (this.isTempFile(f)) {
            if (this.cache.containsKey(f)) {
                Entry entry = this.cache.get(f);
                if (entry.doc != null) {
                    return entry.doc;
                }
                if (entry.node != null) {
                    NodeInfo nodeInfo = entry.node.getUnderlyingNode();
                    Document doc = (Document)NodeOverNodeInfo.wrap((NodeInfo)nodeInfo);
                    this.put(f, new Entry(doc, entry.node, null));
                    return doc;
                }
                if (entry.bytes != null) {
                    Document document;
                    ByteArrayInputStream in = new ByteArrayInputStream(entry.bytes);
                    try {
                        Document doc = XMLUtils.getDocumentBuilder().parse(in, f.toString());
                        this.put(f, new Entry(doc, null, entry.bytes));
                        document = doc;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (SAXException e) {
                            throw new IOException(e);
                        }
                    }
                    ((InputStream)in).close();
                    return document;
                }
                throw new IllegalArgumentException();
            }
            this.cacheMiss(f);
        }
        return this.fallback.getDocument(path);
    }

    @Override
    public XdmNode getImmutableNode(URI path) throws IOException {
        URI f = this.toAbsolute(path);
        if (this.isTempFile(f)) {
            block12: {
                if (this.cache.containsKey(f)) {
                    Entry entry = this.cache.get(f);
                    if (entry.node != null) {
                        return entry.node;
                    }
                    if (entry.doc != null) {
                        XdmNode node = this.xmlUtils.getProcessor().newDocumentBuilder().wrap((Object)entry.doc);
                        this.put(f, new Entry(entry.doc, node, entry.bytes));
                        return node;
                    }
                    if (entry.bytes != null) {
                        try (ByteArrayInputStream in = new ByteArrayInputStream(entry.bytes);){
                            StreamSource source = new StreamSource(in);
                            source.setSystemId(f.toString());
                            XdmNode node = this.xmlUtils.getProcessor().newDocumentBuilder().build((Source)source);
                            this.put(f, new Entry(entry.doc, node, entry.bytes));
                            break block12;
                        }
                        catch (SaxonApiException e) {
                            throw new IOException(e);
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            this.cacheMiss(f);
        }
        return this.fallback.getImmutableNode(path);
    }

    @Override
    public Document getDocument(URI path) throws IOException {
        URI f = this.toAbsolute(path);
        if (this.isTempFile(f)) {
            if (this.cache.containsKey(f)) {
                Entry entry = this.get(f);
                if (entry.doc != null) {
                    return (Document)entry.doc.cloneNode(true);
                }
                if (entry.node != null) {
                    return this.xmlUtils.cloneDocument(entry.node);
                }
                if (entry.bytes != null) {
                    Document document;
                    ByteArrayInputStream in = new ByteArrayInputStream(entry.bytes);
                    try {
                        InputSource inputSource = new InputSource(in);
                        inputSource.setSystemId(f.toString());
                        Document doc = XMLUtils.getDocumentBuilder().parse(inputSource);
                        this.put(f, new Entry(doc, entry.node, entry.bytes));
                        document = doc;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (SAXException e) {
                            throw new IOException(e);
                        }
                    }
                    ((InputStream)in).close();
                    return document;
                }
                throw new IllegalArgumentException();
            }
            this.cacheMiss(f);
        }
        return this.fallback.getDocument(path);
    }

    @Override
    public void writeDocument(Document doc, URI path) throws IOException {
        if (this.isTempFile(path)) {
            doc.setDocumentURI(path.toString());
            DocumentBuilder documentBuilder = this.xmlUtils.getProcessor().newDocumentBuilder();
            DOMSource domSource = new DOMSource(doc, doc.getBaseURI());
            if (doc.getBaseURI() == null || doc.getBaseURI().isEmpty()) {
                domSource.setSystemId(doc.getBaseURI());
            }
            XdmNode node = documentBuilder.wrap((Object)domSource);
            this.put(path, new Entry(null, node, null));
        } else {
            this.fallback.writeDocument(doc, path);
        }
    }

    @Override
    public void writeDocument(XdmNode node, URI path) throws IOException {
        if (this.isTempFile(path)) {
            this.put(path, new Entry(null, node, null));
        } else {
            this.fallback.writeDocument(node, path);
        }
    }

    @Override
    public void writeDocument(Node doc, ContentHandler dst) throws IOException {
        this.fallback.writeDocument(doc, dst);
    }

    @Override
    public void writeDocument(XdmNode node, ContentHandler dst) throws IOException {
        this.fallback.writeDocument(node, dst);
    }

    @Override
    public Destination getDestination(URI path) throws IOException {
        if (this.isTempFile(path)) {
            XdmDestination dst = new XdmDestination();
            dst.setBaseURI(path);
            dst.onClose(() -> {
                XdmNode node = dst.getXdmNode();
                this.put(path, new Entry(null, node, null));
            });
            return dst;
        }
        return this.fallback.getDestination(path);
    }

    @Override
    public ContentHandler getContentHandler(URI outputFile) throws SaxonApiException, IOException {
        Configuration configuration = this.xmlUtils.getProcessor().getUnderlyingConfiguration();
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        Destination dst = this.getDestination(outputFile);
        Receiver receiver = dst.getReceiver(pipelineConfiguration, new SerializationProperties());
        try {
            receiver.open();
        }
        catch (XPathException e) {
            throw new SaxonApiException("Failed to open receiver for %s".formatted(outputFile), (Throwable)e);
        }
        ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
        receivingContentHandler.setPipelineConfiguration(pipelineConfiguration);
        receivingContentHandler.setReceiver(receiver);
        return receivingContentHandler;
    }

    @Override
    public void transform(URI src, ContentHandler dst) throws DITAOTException {
        URI f = src.normalize();
        if (this.isTempFile(f)) {
            if (!this.exists(f)) {
                return;
            }
            if (this.cache.containsKey(f)) {
                try {
                    Source source = this.getSource(src);
                    Receiver receiver = this.getReceiver(dst);
                    Sender.send((Source)source, (Receiver)receiver, (ParseOptions)new ParseOptions());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DITAOTException("Failed to transform " + src + ": " + e.getMessage(), e);
                }
                return;
            }
        }
        this.fallback.transform(src, dst);
    }

    @Override
    public void transform(URI input, List<XMLFilter> filters) throws DITAOTException {
        URI src = input.normalize();
        if (this.isTempFile(src)) {
            if (!this.exists(src)) {
                return;
            }
            try {
                Source source = this.getSource(src);
                ContentHandler serializer = this.getContentHandler(src);
                ContentHandler pipe = this.getPipe(filters, serializer);
                Receiver receiver = this.getReceiver(pipe);
                Sender.send((Source)source, (Receiver)receiver, (ParseOptions)new ParseOptions());
            }
            catch (IOException | SaxonApiException | XPathException e) {
                throw new DITAOTException("Failed to transform " + src + ": " + e.getMessage(), e);
            }
        } else {
            this.fallback.transform(src, filters);
        }
    }

    @Override
    void transformURI(URI input, URI output, List<XMLFilter> filters) throws DITAOTException {
        if (this.isTempFile(input)) {
            if (!this.exists(input)) {
                return;
            }
            try {
                ContentHandler dst = this.getContentHandler(output);
                ContentHandler pipe = this.getPipe(filters, dst);
                this.transform(input, pipe);
            }
            catch (IOException | SaxonApiException e) {
                throw new DITAOTException("Failed to transform " + input + ": " + e.getMessage(), e);
            }
            return;
        }
        this.fallback.transformURI(input, output, filters);
    }

    @Override
    public void transform(URI input, URI output, XsltTransformer transformer) throws DITAOTException {
        URI dst;
        URI src = input.normalize();
        if (src.equals(dst = output.normalize())) {
            this.transform(src, transformer);
        } else {
            this.transformUri(src, dst, transformer);
        }
    }

    @Override
    public void transform(URI src, XsltTransformer transformer) throws DITAOTException {
        if (!this.exists(src)) {
            return;
        }
        boolean useTmpBuf = !this.isTempFile(src.normalize());
        URI dst = useTmpBuf ? URLUtils.toURI(src + ".temp").normalize() : src;
        Destination result = null;
        try {
            Source source = this.getSource(src);
            transformer.setSource(source);
            result = this.getDestination(dst);
            result.setDestinationBaseURI(src);
            transformer.setDestination(result);
            transformer.transform();
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to transform document", e);
        }
        catch (SaxonApiException e) {
            throw new DITAOTException("Failed to transform document: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to replace " + src + ": " + e.getMessage());
        }
        finally {
            try {
                result.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException("Failed to transform document", e);
            }
        }
        if (useTmpBuf) {
            try {
                this.move(dst, src);
            }
            catch (IOException e) {
                throw new DITAOTException("Failed to replace " + src + ": " + e.getMessage());
            }
        }
    }

    @Override
    void transformUri(URI src, URI dst, XsltTransformer transformer) throws DITAOTException {
        if (!this.exists(src)) {
            return;
        }
        Destination result = null;
        try {
            Source source = this.getSource(src);
            transformer.setSource(source);
            result = this.getDestination(dst);
            transformer.setDestination(result);
            transformer.transform();
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to transform document", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to transform document: " + e.getMessage(), e);
        }
        finally {
            try {
                result.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException("Failed to transform document", e);
            }
        }
    }

    @Override
    public InputStream getInputStream(URI path) throws IOException {
        URI f = path.normalize();
        if (this.isTempFile(f) && this.cache.containsKey(f)) {
            Entry entry = this.cache.get(f);
            if (entry.bytes != null) {
                return new ByteArrayInputStream(entry.bytes);
            }
            if (entry.node != null) {
                ByteArrayInputStream byteArrayInputStream;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                try {
                    XdmNode source = entry.node;
                    Serializer serializer = this.xmlUtils.getProcessor().newSerializer((OutputStream)buf);
                    serializer.serializeNode(source);
                    byte[] bytes = buf.toByteArray();
                    this.cache.put(f, new Entry(entry.doc, entry.node, bytes));
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                }
                catch (Throwable source) {
                    try {
                        try {
                            buf.close();
                        }
                        catch (Throwable serializer) {
                            source.addSuppressed(serializer);
                        }
                        throw source;
                    }
                    catch (SaxonApiException e) {
                        throw new IOException(e);
                    }
                }
                buf.close();
                return byteArrayInputStream;
            }
            if (entry.doc != null) {
                ByteArrayInputStream byteArrayInputStream;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                try {
                    XdmNode source = this.xmlUtils.getProcessor().newDocumentBuilder().wrap((Object)entry.doc);
                    Serializer serializer = this.xmlUtils.getProcessor().newSerializer((OutputStream)buf);
                    serializer.serializeNode(source);
                    byte[] bytes = buf.toByteArray();
                    this.cache.put(f, new Entry(entry.doc, entry.node, bytes));
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            buf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (SaxonApiException e) {
                        throw new IOException(e);
                    }
                }
                buf.close();
                return byteArrayInputStream;
            }
        }
        return this.fallback.getInputStream(path);
    }

    @Override
    public OutputStream getOutputStream(URI path) throws IOException {
        URI f = this.getUri(path);
        if (this.isTempFile(f)) {
            return new OutputStreamBuffer(f);
        }
        return this.fallback.getOutputStream(f);
    }

    private ContentHandler getPipe(List<XMLFilter> filters, ContentHandler dst1) {
        ArrayList<XMLFilter> rev = new ArrayList<XMLFilter>(filters);
        Collections.reverse(rev);
        for (XMLFilter filter : rev) {
            XMLFilterImpl filterImpl = (XMLFilterImpl)filter;
            filterImpl.setContentHandler(dst1);
            dst1 = filterImpl;
        }
        return dst1;
    }

    private Receiver getReceiver(ContentHandler dst) {
        SAXDestination result = new SAXDestination(dst);
        PipelineConfiguration pipe = this.xmlUtils.getProcessor().getUnderlyingConfiguration().makePipelineConfiguration();
        return result.getReceiver(pipe, new SerializationProperties());
    }

    private URI toAbsolute(URI path) {
        return (path.isAbsolute() ? path : this.tempDirUri.resolve(path)).normalize();
    }

    private void cacheMiss(URI f) {
    }

    private Entry put(URI path, Entry entry) {
        if (entry.node != null) {
            XdmNode node = entry.node;
            assert (node.getBaseURI() != null && !node.getBaseURI().toString().isEmpty());
            assert (node.getUnderlyingNode().getBaseURI() != null && !node.getUnderlyingNode().getBaseURI().isEmpty());
        }
        if (entry.doc != null) {
            Document doc = entry.doc;
            assert (doc.getBaseURI() != null && !doc.getBaseURI().isEmpty());
        }
        return this.cache.put(path, entry);
    }

    private Entry get(URI s) {
        Entry entry = this.cache.get(s);
        if (entry.node != null) {
            XdmNode node = entry.node;
            assert (node.getBaseURI() != null && !node.getBaseURI().toString().isEmpty());
            assert (node.getUnderlyingNode().getBaseURI() != null && !node.getUnderlyingNode().getBaseURI().isEmpty());
        } else if (entry.doc != null) {
            Document node = entry.doc;
            assert (node.getBaseURI() != null && !node.getBaseURI().isEmpty());
        }
        return entry;
    }

    private Entry remove(URI f) {
        Entry entry = this.cache.remove(f);
        if (entry.node != null) {
            XdmNode node = entry.node;
            assert (node.getBaseURI() != null && !node.getBaseURI().toString().isEmpty());
            assert (node.getUnderlyingNode().getBaseURI() != null && !node.getUnderlyingNode().getBaseURI().isEmpty());
        } else if (entry.doc != null) {
            Document node = entry.doc;
            assert (node.getBaseURI() != null && !node.getBaseURI().isEmpty());
        }
        return entry;
    }

    private Entry rebase(Entry remove, URI d) {
        XdmNode node = null;
        Document doc = null;
        if (remove.node != null) {
            TreeInfo treeInfo = remove.node.getUnderlyingNode().getTreeInfo();
            RebasedDocument rebasedDocument = new RebasedDocument(treeInfo, nodeInfo -> d.toString(), nodeInfo -> d.toString());
            rebasedDocument.setSystemId(d.toString());
            DocumentBuilder builder = this.xmlUtils.getProcessor().newDocumentBuilder();
            builder.setBaseURI(d);
            node = builder.wrap((Object)rebasedDocument.getRootNode());
        }
        if (remove.doc != null) {
            remove.doc.setDocumentURI(d.toString());
            doc = remove.doc;
        }
        return new Entry(doc, node, remove.bytes);
    }

    private Source toSource(Entry entry, URI path) {
        if (entry.doc != null) {
            return new DOMSource(entry.doc);
        }
        if (entry.node != null) {
            NodeInfo underlyingNode = entry.node.getUnderlyingNode();
            if (underlyingNode.getSystemId().equals(path.toString())) {
                return underlyingNode;
            }
            Entry rebase = this.rebase(entry, path);
            return rebase.node.asSource();
        }
        if (entry.bytes != null) {
            StreamSource source = new StreamSource(new ByteArrayInputStream(entry.bytes));
            source.setSystemId(path.toString());
            return source;
        }
        throw new IllegalArgumentException();
    }

    private static class Entry {
        private final Document doc;
        private final XdmNode node;
        private final byte[] bytes;
        private final long lastModified;

        private Entry(Document doc, XdmNode node, byte[] bytes) {
            this(doc, node, bytes, System.currentTimeMillis());
        }

        private Entry(Document doc, XdmNode node, byte[] bytes, long lastModified) {
            this.doc = doc;
            this.node = node;
            this.bytes = bytes;
            this.lastModified = lastModified;
        }
    }

    private class OutputStreamBuffer
    extends ByteArrayOutputStream {
        private final URI path;

        private OutputStreamBuffer(URI path) {
            this.path = path;
        }

        @Override
        public void close() throws IOException {
            super.close();
            CacheStore.this.put(this.path, new Entry(null, null, this.toByteArray()));
        }
    }
}

