/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class FilterUtils {
    public static final String SUBJECT_SCHEME_EXTENSION = ".subm";
    public static final FilterKey DEFAULT = new FilterKey(QName.valueOf("default"), null);
    private static final String FLAG_STYLE_PREFIX = "flag__style--";
    private DITAOTLogger logger;
    final Map<FilterKey, Action> filterMap;
    private final Set<FilterKey> notMappingRules = new HashSet<FilterKey>();
    private boolean logMissingAction;
    private final String foregroundConflictColor;
    private final String backgroundConflictColor;
    private Set<QName> filterAttributes;
    private Set<QName> flagAttributes;
    private final Pattern groupPattern = Pattern.compile("(\\w+)\\((.*?)\\)");

    public FilterUtils(Map<FilterKey, Action> filterMap, String foregroundConflictColor, String backgroundConflictColor) {
        this.logMissingAction = !filterMap.isEmpty();
        this.filterMap = new HashMap<FilterKey, Action>(filterMap);
        this.foregroundConflictColor = foregroundConflictColor;
        this.backgroundConflictColor = backgroundConflictColor;
        this.filterAttributes = FilterUtils.getProfileAttributes(Configuration.configuration.get("filter-attributes"));
        this.flagAttributes = FilterUtils.getFlaggingAttributes(Configuration.configuration.get("flag-attributes"));
    }

    public FilterUtils(boolean isPrintType) {
        this(isPrintType, Collections.emptyMap(), null, null);
    }

    public FilterUtils(boolean isPrintType, Map<FilterKey, Action> filterMap, String foregroundConflictColor, String backgroundConflictColor) {
        HashMap<FilterKey, Action> dfm = new HashMap<FilterKey, Action>();
        dfm.put(new FilterKey(QName.valueOf("print"), "yes"), Action.INCLUDE);
        if (isPrintType) {
            dfm.put(new FilterKey(QName.valueOf("print"), "printonly"), Action.INCLUDE);
            dfm.put(new FilterKey(QName.valueOf("print"), "no"), Action.EXCLUDE);
        } else {
            dfm.put(new FilterKey(QName.valueOf("print"), "printonly"), Action.EXCLUDE);
            dfm.put(new FilterKey(QName.valueOf("print"), "no"), Action.INCLUDE);
        }
        dfm.put(new FilterKey(QName.valueOf("print"), null), Action.INCLUDE);
        dfm.putAll(filterMap);
        this.logMissingAction = !filterMap.isEmpty();
        this.filterMap = dfm;
        this.foregroundConflictColor = foregroundConflictColor;
        this.backgroundConflictColor = backgroundConflictColor;
        this.filterAttributes = FilterUtils.getProfileAttributes(Configuration.configuration.get("filter-attributes"));
        this.flagAttributes = FilterUtils.getFlaggingAttributes(Configuration.configuration.get("flag-attributes"));
    }

    @VisibleForTesting
    public FilterUtils(boolean isPrintType, Map<FilterKey, Action> filterMap, String foregroundConflictColor, String backgroundConflictColor, Set<QName> filterAttributes, Set<QName> flagAttributes) {
        this(isPrintType, filterMap, foregroundConflictColor, backgroundConflictColor);
        this.filterAttributes = Sets.union(this.filterAttributes, filterAttributes);
        this.flagAttributes = Sets.union(this.flagAttributes, flagAttributes);
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public String toString() {
        return this.filterMap.toString();
    }

    private static Set<QName> getProfileAttributes(String conf) {
        ImmutableSet.Builder res = ImmutableSet.builder().add((Object[])new QName[]{QName.valueOf("audience"), QName.valueOf("platform"), QName.valueOf("product"), QName.valueOf("otherprops"), QName.valueOf("props"), QName.valueOf("print"), QName.valueOf("deliveryTarget")});
        if (conf != null) {
            Stream.of(conf.trim().split("\\s*,\\s*")).map(QName::valueOf).forEach(arg_0 -> ((ImmutableSet.Builder)res).add(arg_0));
        }
        return res.build();
    }

    private static Set<QName> getFlaggingAttributes(String conf) {
        ImmutableSet.Builder res = ImmutableSet.builder().add((Object[])new QName[]{QName.valueOf("audience"), QName.valueOf("platform"), QName.valueOf("product"), QName.valueOf("otherprops"), QName.valueOf("props"), QName.valueOf("print"), QName.valueOf("deliveryTarget"), QName.valueOf("rev")});
        if (conf != null) {
            Stream.of(conf.trim().split("\\s*,\\s*")).map(QName::valueOf).forEach(arg_0 -> ((ImmutableSet.Builder)res).add(arg_0));
        }
        return res.build();
    }

    public Set<Flag> getFlags(Attributes atts, QName[][] extProps) {
        if (this.filterMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Flag> res = new HashSet<Flag>();
        for (QName attr : this.flagAttributes) {
            String value = atts.getValue(attr.getNamespaceURI(), attr.getLocalPart());
            if (value == null) continue;
            Map<QName, List<String>> groups = this.getGroups(value);
            for (Map.Entry<QName, List<String>> group : groups.entrySet()) {
                QName[] qNameArray;
                if (group.getKey() != null) {
                    QName[] qNameArray2 = new QName[2];
                    qNameArray2[0] = attr;
                    qNameArray = qNameArray2;
                    qNameArray2[1] = group.getKey();
                } else {
                    QName[] qNameArray3 = new QName[1];
                    qNameArray = qNameArray3;
                    qNameArray3[0] = attr;
                }
                QName[] propList = qNameArray;
                res.addAll(this.extCheckFlag(propList, group.getValue()));
            }
        }
        if (extProps != null && extProps.length != 0) {
            for (QName[] propList : extProps) {
                int propListIndex = propList.length - 1;
                QName propName = propList[propListIndex];
                String propValue = atts.getValue(propName.getNamespaceURI(), propName.getLocalPart());
                while ((propValue == null || propValue.trim().isEmpty()) && propListIndex > 0) {
                    QName current = propList[--propListIndex];
                    propValue = this.getLabelValue(propName, atts.getValue(current.getNamespaceURI(), current.getLocalPart()));
                }
                if (propValue == null) continue;
                res.addAll(this.extCheckFlag(propList, Arrays.asList(propValue.split("\\s+"))));
            }
        }
        return this.checkConflict(res);
    }

    private Set<Flag> checkConflict(Set<Flag> res) {
        boolean conflictBackcolor;
        if (this.foregroundConflictColor == null && this.backgroundConflictColor == null) {
            return res;
        }
        HashSet<String> color = new HashSet<String>();
        HashSet<String> backcolor = new HashSet<String>();
        for (Flag f2 : res) {
            if (f2.color != null) {
                color.add(f2.color);
            }
            if (f2.backcolor == null) continue;
            backcolor.add(f2.backcolor);
        }
        boolean conflictColor = color.size() > 1;
        boolean bl = conflictBackcolor = backcolor.size() > 1;
        if (conflictColor && this.foregroundConflictColor != null || conflictBackcolor && this.backgroundConflictColor != null) {
            return res.stream().map(f -> new Flag("prop", conflictColor ? this.foregroundConflictColor : f.color, conflictBackcolor ? this.backgroundConflictColor : f.backcolor, f.style, f.changebar, f.startflag, f.endflag, f.outputClass)).collect(Collectors.toSet());
        }
        return res;
    }

    public Set<Flag> getFlags(Element element, QName[][] props) {
        XMLUtils.AttributesBuilder buf = new XMLUtils.AttributesBuilder();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getNodeType() != 2) continue;
            buf.add((Attr)attr);
        }
        return this.getFlags(buf.build(), props);
    }

    @VisibleForTesting
    List<Flag> extCheckFlag(QName[] propList, List<String> attValue) {
        ArrayList<Flag> res = new ArrayList<Flag>();
        for (QName attName : propList) {
            for (String attSubValue : attValue) {
                Action filterAction = this.filterMap.get(new FilterKey(attName, attSubValue));
                if (filterAction == null) {
                    filterAction = this.filterMap.get(new FilterKey(attName, null));
                }
                if (!(filterAction instanceof Flag)) continue;
                res.add((Flag)filterAction);
            }
        }
        return res;
    }

    public boolean needExclude(Element element, QName[][] props) {
        XMLUtils.AttributesBuilder buf = new XMLUtils.AttributesBuilder();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getNodeType() != 2) continue;
            buf.add((Attr)attr);
        }
        return this.needExclude(buf.build(), props);
    }

    public boolean needExclude(Attributes atts, QName[][] extProps) {
        if (this.filterMap.isEmpty()) {
            return false;
        }
        for (QName attr : this.filterAttributes) {
            String value = atts.getValue(attr.getNamespaceURI(), attr.getLocalPart());
            if (value == null) continue;
            Map<QName, List<String>> groups = this.getGroups(value);
            for (Map.Entry<QName, List<String>> group : groups.entrySet()) {
                QName[] propList;
                QName[] qNameArray;
                if (group.getKey() != null) {
                    QName[] qNameArray2 = new QName[2];
                    qNameArray2[0] = attr;
                    qNameArray = qNameArray2;
                    qNameArray2[1] = group.getKey();
                } else {
                    QName[] qNameArray3 = new QName[1];
                    qNameArray = qNameArray3;
                    qNameArray3[0] = attr;
                }
                if (!this.extCheckExclude(propList = qNameArray, group.getValue())) continue;
                return true;
            }
        }
        if (extProps != null && extProps.length != 0) {
            for (QName[] propList : extProps) {
                int propListIndex = propList.length - 1;
                QName propName = propList[propListIndex];
                String propValue = atts.getValue(propName.getNamespaceURI(), propName.getLocalPart());
                while ((propValue == null || propValue.trim().isEmpty()) && propListIndex > 0) {
                    QName current = propList[--propListIndex];
                    propValue = this.getLabelValue(propName, atts.getValue(current.getNamespaceURI(), current.getLocalPart()));
                }
                if (propValue == null || !this.extCheckExclude(propList, Arrays.asList(propValue.split("\\s+")))) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    Map<QName, List<String>> getGroups(String value) {
        HashMap<QName, List<String>> res = new HashMap<QName, List<String>>();
        StringBuilder buf = new StringBuilder();
        int previousEnd = 0;
        Matcher m = this.groupPattern.matcher(value);
        while (m.find()) {
            buf.append(value.subSequence(previousEnd, m.start()));
            String v = m.group(2);
            if (!v.trim().isEmpty()) {
                QName k = QName.valueOf(m.group(1));
                if (res.containsKey(k)) {
                    ArrayList<String> l = new ArrayList<String>((Collection)res.get(k));
                    l.addAll(Arrays.asList(v.trim().split("\\s+")));
                    res.put(k, l);
                } else {
                    res.put(k, Arrays.asList(v.trim().split("\\s+")));
                }
            }
            previousEnd = m.end();
        }
        buf.append(value.substring(previousEnd));
        if (!buf.toString().trim().isEmpty()) {
            res.put(null, Arrays.asList(buf.toString().trim().split("\\s+")));
        }
        return res;
    }

    private String getLabelValue(QName propName, String attrPropsValue) {
        if (attrPropsValue != null) {
            int propStart = -1;
            if (attrPropsValue.startsWith(propName + "(") || attrPropsValue.contains(" " + propName + "(")) {
                propStart = attrPropsValue.indexOf(propName + "(");
            }
            if (propStart != -1) {
                propStart = propStart + propName.toString().length() + 1;
            }
            int propEnd = attrPropsValue.indexOf(")", propStart);
            if (propStart != -1 && propEnd != -1) {
                return attrPropsValue.substring(propStart, propEnd).trim();
            }
        }
        return null;
    }

    @VisibleForTesting
    boolean extCheckExclude(QName[] propList, List<String> attValue) {
        for (int propListIndex = propList.length - 1; propListIndex >= 0; --propListIndex) {
            QName attName = propList[propListIndex];
            this.checkRuleMapping(attName, attValue);
            boolean hasNonExcludeAction = false;
            boolean hasExcludeAction = false;
            for (String attSubValue : attValue) {
                FilterKey filterKey = new FilterKey(attName, attSubValue);
                Action filterAction = this.filterMap.get(filterKey);
                if (filterAction == null) {
                    Action defaultAction = this.filterMap.get(new FilterKey(attName, null));
                    if (defaultAction != null) {
                        if (defaultAction instanceof Exclude) {
                            hasExcludeAction = true;
                            continue;
                        }
                        return false;
                    }
                    if (hasExcludeAction) {
                        if (this.isDefaultExclude()) continue;
                        return false;
                    }
                    hasNonExcludeAction = true;
                    continue;
                }
                if (filterAction instanceof Exclude) {
                    hasExcludeAction = true;
                    if (!hasNonExcludeAction) continue;
                    if (this.isDefaultExclude()) {
                        hasNonExcludeAction = false;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (hasNonExcludeAction) {
                if (0 != propListIndex) continue;
                return this.isDefaultExclude();
            }
            if (!hasExcludeAction) continue;
            return true;
        }
        return false;
    }

    private boolean isDefaultExclude() {
        Action defaultAction = this.filterMap.get(DEFAULT);
        return defaultAction != null && defaultAction instanceof Exclude;
    }

    private void checkRuleMapping(QName attName, List<String> attValue) {
        if (attValue == null || attValue.isEmpty()) {
            return;
        }
        for (String attSubValue : attValue) {
            FilterKey filterKey = new FilterKey(attName, attSubValue);
            Action filterAction = this.filterMap.get(filterKey);
            if (filterAction != null || !this.logMissingAction || this.filterMap.get(DEFAULT) != null || this.filterMap.get(new FilterKey(attName, null)) != null || this.alreadyShowed(filterKey)) continue;
            this.logger.info(MessageUtils.getMessage("DOTJ031I", filterKey.toString()).toString());
        }
    }

    private boolean alreadyShowed(FilterKey notMappingKey) {
        if (!this.notMappingRules.contains(notMappingKey)) {
            this.notMappingRules.add(notMappingKey);
            return false;
        }
        return true;
    }

    public FilterUtils refine(SubjectScheme bindingMap) {
        return this.refine(bindingMap.subjectSchemeMap());
    }

    private FilterUtils refine(Map<QName, Map<String, Set<SubjectScheme.SubjectDefinition>>> bindingMap) {
        if (bindingMap != null && !bindingMap.isEmpty()) {
            HashMap<FilterKey, Action> buf = new HashMap<FilterKey, Action>(this.filterMap);
            for (Map.Entry<FilterKey, Action> e : this.filterMap.entrySet()) {
                this.refineAction(e.getValue(), e.getKey(), bindingMap, buf);
            }
            FilterUtils filterUtils = new FilterUtils(buf, this.foregroundConflictColor, this.backgroundConflictColor);
            filterUtils.setLogger(this.logger);
            filterUtils.logMissingAction = this.logMissingAction;
            return filterUtils;
        }
        return this;
    }

    private void refineAction(Action action, FilterKey key, Map<QName, Map<String, Set<SubjectScheme.SubjectDefinition>>> bindingMap, Map<FilterKey, Action> destFilterMap) {
        Map<String, Set<SubjectScheme.SubjectDefinition>> schemeMap;
        if (key.value != null && (schemeMap = bindingMap.get(key.attribute)) != null && !schemeMap.isEmpty()) {
            for (Set<SubjectScheme.SubjectDefinition> submap : schemeMap.values()) {
                for (SubjectScheme.SubjectDefinition e : submap) {
                    SubjectScheme.SubjectDefinition subRoot = this.searchForKey(e, key.value);
                    if (subRoot == null) continue;
                    this.insertAction(subRoot, key.attribute, action, destFilterMap);
                }
            }
        }
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || !FilterUtils.getKeyValues(node).contains(keyValue)) continue;
            return node;
        }
        return null;
    }

    private SubjectScheme.SubjectDefinition searchForKey(SubjectScheme.SubjectDefinition root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<SubjectScheme.SubjectDefinition> queue = new LinkedList<SubjectScheme.SubjectDefinition>();
        queue.add(root);
        while (!queue.isEmpty()) {
            SubjectScheme.SubjectDefinition node = (SubjectScheme.SubjectDefinition)queue.removeFirst();
            List<SubjectScheme.SubjectDefinition> children = node.children();
            queue.addAll(children);
            if (!node.keys().contains(keyValue)) continue;
            return node;
        }
        return null;
    }

    private static List<String> getKeyValues(Element child) {
        String value = child.getAttribute("keys").trim();
        if (value.isEmpty()) {
            return List.of();
        }
        return Arrays.asList(value.split("\\s+"));
    }

    private void insertAction(SubjectScheme.SubjectDefinition subTree, QName attName, Action action, Map<FilterKey, Action> destFilterMap) {
        if (subTree == null || action == null) {
            return;
        }
        LinkedList<SubjectScheme.SubjectDefinition> queue = new LinkedList<SubjectScheme.SubjectDefinition>();
        List<SubjectScheme.SubjectDefinition> children = subTree.children();
        queue.addAll(children);
        while (!queue.isEmpty()) {
            SubjectScheme.SubjectDefinition node = (SubjectScheme.SubjectDefinition)queue.poll();
            children = node.children();
            queue.addAll(children);
            for (String key : node.keys()) {
                FilterKey k = new FilterKey(attName, key);
                if (destFilterMap.containsKey(k)) continue;
                destFilterMap.put(k, action);
            }
        }
    }

    public record FilterKey(QName attribute, String value) {
        public FilterKey {
            Objects.requireNonNull(attribute, "Attribute may not be null");
        }

        @Override
        public String toString() {
            return this.value != null ? this.attribute.toString() + "=" + this.value : this.attribute.toString();
        }
    }

    public static interface Action {
        public static final Action INCLUDE = new Include();
        public static final Action EXCLUDE = new Exclude();
        public static final Action PASSTHROUGH = new Passthrough();
    }

    public record Flag(String proptype, String color, String backcolor, String[] style, String changebar, FlagImage startflag, FlagImage endflag, String outputClass) implements Action
    {
        public Flag adjustPath(URI currentFile, Job job) {
            return new Flag(this.proptype, this.color, this.backcolor, this.style, this.changebar, this.adjustPath(this.startflag, currentFile, job), this.adjustPath(this.endflag, currentFile, job), this.outputClass);
        }

        private FlagImage adjustPath(FlagImage img, URI currentFile, Job job) {
            URI rel;
            if (img == null) {
                return img;
            }
            Job.FileInfo flagFi = job.getFileInfo(img.href);
            if (flagFi != null) {
                Job.FileInfo current = job.getFileInfo(currentFile);
                URI flag = job.tempDirURI.resolve(flagFi.uri);
                URI curr = job.tempDirURI.resolve(current.uri);
                rel = URLUtils.getRelativePath(curr, flag);
            } else {
                rel = img.href;
            }
            return new FlagImage(rel, img.alt);
        }

        public void writeStartFlag(ContentHandler contentHandler) throws SAXException {
            StringJoiner outputClassAttr = new StringJoiner(" ");
            StringBuilder styleAttr = new StringBuilder();
            if (this.color != null) {
                styleAttr.append("color:").append(this.color).append(";");
            }
            if (this.backcolor != null) {
                styleAttr.append("background-color:").append(this.backcolor).append(";");
            }
            if (this.outputClass != null) {
                outputClassAttr.add(this.outputClass);
            }
            if (this.style != null) {
                for (String style : this.style) {
                    outputClassAttr.add(FilterUtils.FLAG_STYLE_PREFIX + style);
                }
            }
            XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder().add("class", Constants.DITA_OT_D_DITAVAL_STARTPROP.toString());
            if (outputClassAttr.length() != 0) {
                atts.add("outputclass", outputClassAttr.toString());
            }
            if (styleAttr.length() != 0) {
                atts.add("style", styleAttr.toString());
            }
            contentHandler.startElement("", Constants.DITA_OT_D_DITAVAL_STARTPROP.localName, Constants.DITA_OT_D_DITAVAL_STARTPROP.localName, atts.build());
            this.writeProp(contentHandler, true);
            contentHandler.endElement("", Constants.DITA_OT_D_DITAVAL_STARTPROP.localName, Constants.DITA_OT_D_DITAVAL_STARTPROP.localName);
        }

        public void writeEndFlag(ContentHandler contentHandler) throws SAXException {
            contentHandler.startElement("", Constants.DITA_OT_D_DITAVAL_ENDPROP.localName, Constants.DITA_OT_D_DITAVAL_ENDPROP.localName, new XMLUtils.AttributesBuilder().add("class", Constants.DITA_OT_D_DITAVAL_ENDPROP.toString()).build());
            this.writeProp(contentHandler, false);
            contentHandler.endElement("", Constants.DITA_OT_D_DITAVAL_ENDPROP.localName, Constants.DITA_OT_D_DITAVAL_ENDPROP.localName);
        }

        private void writeProp(ContentHandler contentHandler, boolean isStart) throws SAXException {
            XMLUtils.AttributesBuilder propAtts = new XMLUtils.AttributesBuilder().add("action", "flag");
            if (this.color != null) {
                propAtts.add("color", this.color);
            }
            if (this.backcolor != null) {
                propAtts.add("backcolor", this.backcolor);
            }
            if (this.style != null) {
                propAtts.add("style", String.join((CharSequence)" ", this.style));
            }
            if (this.outputClass != null) {
                propAtts.add("outputclass", this.outputClass);
            }
            if (this.changebar != null) {
                propAtts.add("changebar", this.changebar);
            }
            contentHandler.startElement("", this.proptype, this.proptype, propAtts.build());
            if (isStart && this.startflag != null) {
                this.startflag.writeFlag(contentHandler, "startflag");
            }
            if (!isStart && this.endflag != null) {
                this.endflag.writeFlag(contentHandler, "endflag");
            }
            contentHandler.endElement("", this.proptype, this.proptype);
        }

        public Element getStartFlag() {
            return Flag.writeToElement(contentHandler -> {
                try {
                    this.writeStartFlag((ContentHandler)contentHandler);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public Element getEndFlag() {
            return Flag.writeToElement(contentHandler -> {
                try {
                    this.writeEndFlag((ContentHandler)contentHandler);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private static Element writeToElement(final Consumer<ContentHandler> writer) {
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                transformer = factory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            SAXSource xmlSource = new SAXSource(new XMLReader(){
                private ContentHandler contentHandler;

                @Override
                public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
                    return false;
                }

                @Override
                public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
                }

                @Override
                public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
                    return null;
                }

                @Override
                public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
                }

                @Override
                public void setEntityResolver(EntityResolver resolver) {
                }

                @Override
                public EntityResolver getEntityResolver() {
                    return null;
                }

                @Override
                public void setDTDHandler(DTDHandler handler) {
                }

                @Override
                public DTDHandler getDTDHandler() {
                    return null;
                }

                @Override
                public void setContentHandler(ContentHandler handler) {
                    this.contentHandler = handler;
                }

                @Override
                public ContentHandler getContentHandler() {
                    return this.contentHandler;
                }

                @Override
                public void setErrorHandler(ErrorHandler handler) {
                }

                @Override
                public ErrorHandler getErrorHandler() {
                    return null;
                }

                @Override
                public void parse(InputSource input) throws IOException, SAXException {
                    this.parse((String)null);
                }

                @Override
                public void parse(String input) throws IOException, SAXException {
                    this.getContentHandler().startDocument();
                    writer.accept(this.getContentHandler());
                    this.getContentHandler().endDocument();
                }
            }, null);
            DOMResult outputTarget = new DOMResult();
            try {
                transformer.transform(xmlSource, outputTarget);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
            return ((Document)outputTarget.getNode()).getDocumentElement();
        }

        @Override
        public String toString() {
            return "Flag{color='" + this.color + "', backcolor='" + this.backcolor + "', style=" + Arrays.toString(this.style) + ", outputclass=" + this.outputClass + ", changebar='" + this.changebar + "', startflag=" + this.startflag + ", endflag=" + this.endflag + "}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Flag flag = (Flag)o;
            if (!Objects.equals(this.color, flag.color)) {
                return false;
            }
            if (!Objects.equals(this.backcolor, flag.backcolor)) {
                return false;
            }
            if (!Arrays.equals(this.style, flag.style)) {
                return false;
            }
            if (!Objects.equals(this.outputClass, flag.outputClass)) {
                return false;
            }
            if (!Objects.equals(this.changebar, flag.changebar)) {
                return false;
            }
            if (!Objects.equals(this.startflag, flag.startflag)) {
                return false;
            }
            return Objects.equals(this.endflag, flag.endflag);
        }

        @Override
        public int hashCode() {
            int result = this.color != null ? this.color.hashCode() : 0;
            result = 31 * result + (this.backcolor != null ? this.backcolor.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.style);
            result = 31 * result + (this.changebar != null ? this.changebar.hashCode() : 0);
            result = 31 * result + (this.outputClass != null ? this.outputClass.hashCode() : 0);
            result = 31 * result + (this.startflag != null ? this.startflag.hashCode() : 0);
            result = 31 * result + (this.endflag != null ? this.endflag.hashCode() : 0);
            return result;
        }

        public record FlagImage(URI href, String alt) {
            private void writeFlag(ContentHandler contentHandler, String tag) throws SAXException {
                XMLUtils.AttributesBuilder propAtts = new XMLUtils.AttributesBuilder().add("action", "flag");
                URI abs = this.href;
                if (abs != null) {
                    propAtts.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "imagerefuri", "dita-ot:imagerefuri", "CDATA", abs.toString());
                    URI rel = abs;
                    propAtts.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "original-imageref", "dita-ot:original-imageref", "CDATA", rel.toString());
                    propAtts.add("imageref", rel.toString());
                }
                contentHandler.startElement("", tag, tag, propAtts.build());
                if (this.alt != null) {
                    contentHandler.startElement("", "alt-text", "alt-text", XMLUtils.EMPTY_ATTRIBUTES);
                    char[] chars = this.alt.toCharArray();
                    contentHandler.characters(chars, 0, chars.length);
                    contentHandler.endElement("", "alt-text", "alt-text");
                }
                contentHandler.endElement("", tag, tag);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FlagImage flagImage = (FlagImage)o;
                if (!Objects.equals(this.href, flagImage.href)) {
                    return false;
                }
                return Objects.equals(this.alt, flagImage.alt);
            }

            @Override
            public String toString() {
                return "FlagImage{href=" + this.href + ", alt='" + this.alt + "'}";
            }
        }
    }

    public static class Exclude
    implements Action {
        public String toString() {
            return "exclude";
        }
    }

    public static class Passthrough
    implements Action {
        public String toString() {
            return "passthrough";
        }
    }

    public static class Include
    implements Action {
        public String toString() {
            return "include";
        }
    }
}

