/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.util.Objects;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.SAXException;

public class TopicCleanFilter
extends AbstractXMLFilter {
    private static final String URI_STEP = "../";
    private static final String SINGLE_URI_STEP = "./";
    private static final String FILE_STEP = ".." + File.separator;
    private static final String SINGLE_FILE_STEP = "";
    private Job.FileInfo fi;
    private String pathToRootDir;
    private String pathToMapDir;

    public void setFileInfo(Job.FileInfo fi) {
        this.fi = fi;
    }

    @Override
    public void startDocument() throws SAXException {
        int stepsToRootDir = this.fi.result.getPath().split("/").length - 1;
        this.pathToRootDir = stepsToRootDir == 0 ? SINGLE_URI_STEP : URI_STEP.repeat(stepsToRootDir);
        this.pathToMapDir = this.job.getFileInfo(fi -> fi.isInput && Objects.equals(fi.format, "ditamap")).stream().findAny().map(startFile -> {
            String relativePath = URLUtils.getRelativePath(this.fi.uri, startFile.uri).resolve(".").getPath();
            return relativePath;
        }).orElse(null);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        switch (target) {
            case "path2project": {
                this.getContentHandler().processingInstruction(target, this.pathToRootDir.equals(SINGLE_URI_STEP) ? SINGLE_FILE_STEP : this.pathToRootDir.replace('/', File.separatorChar));
                break;
            }
            case "path2project-uri": {
                this.getContentHandler().processingInstruction(target, this.pathToRootDir);
                break;
            }
            case "path2rootmap-uri": {
                this.getContentHandler().processingInstruction(target, this.pathToMapDir != null ? this.pathToMapDir : data);
                break;
            }
            default: {
                this.getContentHandler().processingInstruction(target, data);
            }
        }
    }
}

