/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.index.IndexComparator;
import org.dita.index.IndexDitaProcessor;
import org.dita.index.IndexEntry;
import org.dita.index.IndexEntryFoundListener;
import org.dita.index.IndexGroup;
import org.dita.index.IndexGroupProcessor;
import org.dita.index.IndexPreprocessResult;
import org.dita.index.IndexStringProcessor;
import org.dita.index.configuration.IndexConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class IndexPreprocessor {
    public static final String VALUE_SEPARATOR = ":";
    private static final String ATTR_START = "start";
    private static final String ATTR_END = "end";
    private static final String HASH_PREFIX = "indexid";
    private static final String ELEM_INDEX_GROUPS = "index.groups";
    private static final String ELEM_INDEX_GROUP = "index.group";
    private static final String ELEM_LABEL = "label";
    private static final String ELEM_INDEX_ENTRY = "index.entry";
    private static final String ELEM_FORMATTED_VALUE = "formatted-value";
    private static final String ELEM_REF_ID = "refID";
    private static final String ATTR_INDEXID = "indexid";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_SORT_STRING = "sort-string";
    private static final String ATTR_START_RANGE = "start-range";
    private static final String ATTR_END_RANGE = "end-range";
    private static final String ATTR_NO_PAGE = "no-page";
    private static final String ATTR_SINGLE_PAGE = "single-page";
    private static final String ELEM_SEE_CHILDS = "see-childs";
    private static final String ELEM_SEE_ALSO_CHILDS = "see-also-childs";
    private final String prefix;
    private final String namespaceUrl;
    private final Deque<Boolean> excludedDraftSection = new ArrayDeque<Boolean>();
    private final IndexDitaProcessor indexDitaProcessor;
    private final IndexGroupProcessor indexGroupProcessor;
    private final boolean includeDraft;

    public IndexPreprocessor(String prefix, String namespaceUrl, boolean includeDraft) {
        this.prefix = prefix;
        this.namespaceUrl = namespaceUrl;
        this.excludedDraftSection.add(false);
        this.includeDraft = includeDraft;
        this.indexDitaProcessor = new IndexDitaProcessor();
        this.indexGroupProcessor = new IndexGroupProcessor();
    }

    public void setLogger(DITAOTLogger logger) {
        this.indexDitaProcessor.setLogger(logger);
        this.indexGroupProcessor.setLogger(logger);
    }

    IndexPreprocessResult process(Document input) {
        DocumentBuilder documentBuilder = XMLUtils.getDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element rootElement = input.getDocumentElement();
        ArrayList<IndexEntry> indexes = new ArrayList<IndexEntry>();
        Node node = this.processCurrNode(rootElement, doc, indexes::add).get(0);
        doc.appendChild(node);
        doc.getDocumentElement().setAttribute("xmlns:" + this.prefix, this.namespaceUrl);
        return new IndexPreprocessResult(doc, indexes);
    }

    void createAndAddIndexGroups(Collection<IndexEntry> indexEntries, IndexConfiguration configuration, Document document, Locale locale) {
        IndexComparator indexEntryComparator = new IndexComparator(locale);
        List<IndexGroup> indexGroups = this.indexGroupProcessor.process(indexEntries, configuration, locale);
        Element rootElement = document.getDocumentElement();
        Element indexGroupsElement = document.createElementNS(this.namespaceUrl, ELEM_INDEX_GROUPS);
        indexGroupsElement.setPrefix(this.prefix);
        for (IndexGroup group : indexGroups) {
            Element groupElement = document.createElementNS(this.namespaceUrl, ELEM_INDEX_GROUP);
            groupElement.setPrefix(this.prefix);
            Element groupLabelElement = document.createElementNS(this.namespaceUrl, ELEM_LABEL);
            groupLabelElement.setPrefix(this.prefix);
            groupLabelElement.appendChild(document.createTextNode(group.getLabel()));
            groupElement.appendChild(groupLabelElement);
            List<Node> entryNodes = this.transformToNodes(new ArrayList<IndexEntry>(group.getEntries()), document, indexEntryComparator);
            for (Node entryNode : entryNodes) {
                groupElement.appendChild(entryNode);
            }
            indexGroupsElement.appendChild(groupElement);
        }
        rootElement.appendChild(indexGroupsElement);
    }

    private List<Node> processCurrNode(Node node, Document targetDocument, IndexEntryFoundListener indexEntryFoundListener) {
        if (this.isDitaIndexElement(node) && !this.excludedDraftSection.peek().booleanValue()) {
            return this.processIndexNode(node, targetDocument, indexEntryFoundListener);
        }
        Node result = targetDocument.importNode(node, false);
        if (!this.includeDraft && this.checkDraftNode(node)) {
            this.excludedDraftSection.push(true);
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            List<Node> processedNodes = this.processCurrNode(child, targetDocument, indexEntryFoundListener);
            for (Node processedNode : processedNodes) {
                result.appendChild(processedNode);
            }
        }
        if (!this.includeDraft && this.checkDraftNode(node)) {
            this.excludedDraftSection.pop();
        }
        return Collections.singletonList(result);
    }

    private List<Node> processIndexNode(Node node, Document targetDocument, IndexEntryFoundListener indexEntryFoundListener) {
        String textNode;
        node.normalize();
        boolean ditastyle = false;
        NodeList childNodes = node.getChildNodes();
        StringBuilder textBuf = new StringBuilder();
        ArrayList<Node> contents = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (this.isDitaIndexElement(child)) {
                ditastyle = true;
                break;
            }
            if (child.getNodeType() == 1) {
                textBuf.append(XMLUtils.getStringValue((Element)((Element)child)));
                contents.add(child);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            textBuf.append(child.getNodeValue());
            contents.add(child);
        }
        if ((textNode = IndexStringProcessor.normalizeTextValue(textBuf.toString())).isEmpty()) {
            textNode = null;
        }
        if (node.getAttributes().getNamedItem(ATTR_START) != null || node.getAttributes().getNamedItem(ATTR_END) != null) {
            ditastyle = true;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        if (ditastyle) {
            List<IndexEntry> indexEntries = this.indexDitaProcessor.processIndexDitaNode(node, "");
            for (IndexEntry indexEntrie : indexEntries) {
                indexEntryFoundListener.foundEntry(indexEntrie);
            }
            List<Node> nodes = this.transformToNodes(indexEntries, targetDocument, null);
            res.addAll(nodes);
        } else if (textNode != null) {
            List<Node> nodes = this.processIndexString(textNode, contents, targetDocument, indexEntryFoundListener);
            res.addAll(nodes);
        } else {
            return Collections.emptyList();
        }
        return res;
    }

    private boolean isDitaIndexElement(Node node) {
        return Constants.TOPIC_INDEXTERM.matches(node) || Constants.INDEXING_D_INDEX_SORT_AS.matches(node) || Constants.INDEXING_D_INDEX_SEE.matches(node) || Constants.INDEXING_D_INDEX_SEE_ALSO.matches(node);
    }

    private boolean checkDraftNode(Node node) {
        return Constants.TOPIC_DRAFT_COMMENT.matches(node) || Constants.TOPIC_REQUIRED_CLEANUP.matches(node);
    }

    private List<Node> processIndexString(String indexString, List<Node> contents, Document targetDocument, IndexEntryFoundListener indexEntryFoundListener) {
        List<IndexEntry> indexEntries = IndexStringProcessor.processIndexString(indexString, contents);
        for (IndexEntry indexEntrie : indexEntries) {
            indexEntryFoundListener.foundEntry(indexEntrie);
        }
        return this.transformToNodes(indexEntries, targetDocument, null);
    }

    private List<Node> transformToNodes(List<IndexEntry> indexEntries, Document targetDocument, Comparator<IndexEntry> indexEntryComparator) {
        if (null != indexEntryComparator) {
            indexEntries.sort(indexEntryComparator);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (IndexEntry indexEntry : indexEntries) {
            List<IndexEntry> seeAlsoChildIndexEntries;
            String sort;
            Element indexEntryNode = this.createElement(targetDocument, ELEM_INDEX_ENTRY);
            Element formattedStringElement = this.createElement(targetDocument, ELEM_FORMATTED_VALUE);
            if (indexEntry.getContents() != null) {
                Iterator<Node> i = indexEntry.getContents().iterator();
                while (i.hasNext()) {
                    Node child = i.next();
                    Node clone = targetDocument.importNode(child, true);
                    if (!i.hasNext() && clone.getNodeType() == 3) {
                        Text t = (Text)clone;
                        t.setData(t.getData().replaceAll("[\\s\\n]+$", ""));
                    }
                    formattedStringElement.appendChild(clone);
                }
            } else {
                Text textNode = targetDocument.createTextNode(indexEntry.getFormattedString());
                textNode.normalize();
                formattedStringElement.appendChild(textNode);
            }
            indexEntryNode.appendChild(formattedStringElement);
            Set<String> refIDs = indexEntry.getRefIDs();
            for (String refID : refIDs) {
                Element referenceIDElement = this.createElement(targetDocument, ELEM_REF_ID);
                referenceIDElement.setAttribute("indexid", "indexid" + refID.hashCode());
                referenceIDElement.setAttribute(ATTR_VALUE, refID);
                indexEntryNode.appendChild(referenceIDElement);
            }
            String val = indexEntry.getValue();
            if (null != val) {
                indexEntryNode.setAttribute(ATTR_VALUE, val);
            }
            if (null != (sort = indexEntry.getSortString())) {
                indexEntryNode.setAttribute(ATTR_SORT_STRING, sort);
            }
            if (indexEntry.isStartingRange()) {
                indexEntryNode.setAttribute(ATTR_START_RANGE, "true");
            } else if (indexEntry.isEndingRange()) {
                indexEntryNode.setAttribute(ATTR_END_RANGE, "true");
            }
            if (indexEntry.isSuppressesThePageNumber()) {
                indexEntryNode.setAttribute(ATTR_NO_PAGE, "true");
            } else if (indexEntry.isRestoresPageNumber()) {
                indexEntryNode.setAttribute(ATTR_SINGLE_PAGE, "true");
            }
            List<IndexEntry> childIndexEntries = indexEntry.getChildIndexEntries();
            List<Node> nodes = this.transformToNodes(childIndexEntries, targetDocument, indexEntryComparator);
            for (Node node : nodes) {
                indexEntryNode.appendChild(node);
            }
            List<IndexEntry> seeChildIndexEntries = indexEntry.getSeeChildIndexEntries();
            if (seeChildIndexEntries != null && !seeChildIndexEntries.isEmpty()) {
                Element seeElement = this.createElement(targetDocument, ELEM_SEE_CHILDS);
                List<Node> seeNodes = this.transformToNodes(seeChildIndexEntries, targetDocument, indexEntryComparator);
                for (Node node : seeNodes) {
                    seeElement.appendChild(node);
                }
                indexEntryNode.appendChild(seeElement);
            }
            if ((seeAlsoChildIndexEntries = indexEntry.getSeeAlsoChildIndexEntries()) != null && !seeAlsoChildIndexEntries.isEmpty()) {
                Element seeAlsoElement = this.createElement(targetDocument, ELEM_SEE_ALSO_CHILDS);
                List<Node> seeAlsoNodes = this.transformToNodes(seeAlsoChildIndexEntries, targetDocument, indexEntryComparator);
                for (Node node : seeAlsoNodes) {
                    seeAlsoElement.appendChild(node);
                }
                indexEntryNode.appendChild(seeAlsoElement);
            }
            result.add(indexEntryNode);
        }
        return result;
    }

    private Element createElement(Document targetDocument, String name) {
        Element indexEntryNode = targetDocument.createElementNS(this.namespaceUrl, name);
        indexEntryNode.setPrefix(this.prefix);
        return indexEntryNode;
    }
}

